/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.optimize.Solver;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.util.FeatureUtil;

public abstract class BaseOutputLayer<LayerConfT extends org.deeplearning4j.nn.conf.layers.BaseOutputLayer>
extends BaseLayer<LayerConfT>
implements Serializable,
IOutputLayer {
    protected INDArray labels;
    private transient Solver solver;
    private double fullNetworkL1;
    private double fullNetworkL2;
    protected INDArray inputMaskArray;
    protected MaskState inputMaskArrayState;

    public BaseOutputLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseOutputLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double computeScore(double fullNetworkL1, double fullNetworkL2, boolean training) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        this.fullNetworkL1 = fullNetworkL1;
        this.fullNetworkL2 = fullNetworkL2;
        INDArray preOut = this.preOutput2d(training);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFn(), this.maskArray, false);
        score += fullNetworkL1 + fullNetworkL2;
        this.score = score /= (double)this.getInputMiniBatchSize();
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetworkL1, double fullNetworkL2) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray preOut = this.preOutput2d(false);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFn(), this.maskArray);
        double l1l2 = fullNetworkL1 + fullNetworkL2;
        if (l1l2 != 0.0) {
            scoreArray.addi((Number)l1l2);
        }
        return scoreArray;
    }

    @Override
    public void computeGradientAndScore() {
        if (this.input == null || this.labels == null) {
            return;
        }
        INDArray preOut = this.preOutput2d(true);
        Pair<Gradient, INDArray> pair = this.getGradientsAndDelta(preOut);
        this.gradient = pair.getFirst();
        this.score = this.computeScore(this.fullNetworkL1, this.fullNetworkL2, true);
    }

    @Override
    protected void setScoreWithZ(INDArray z) {
        throw new RuntimeException("Not supported - " + this.layerId());
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        Pair<Gradient, INDArray> pair = this.getGradientsAndDelta(this.preOutput2d(true));
        INDArray delta = pair.getSecond();
        INDArray epsilonNext = ((INDArray)this.params.get("W")).mmul(delta.transpose()).transpose();
        return new Pair<Gradient, INDArray>(pair.getFirst(), epsilonNext);
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    private Pair<Gradient, INDArray> getGradientsAndDelta(INDArray preOut) {
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        INDArray labels2d = this.getLabels2d();
        INDArray delta = lossFunction.computeGradient(labels2d, preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFn(), this.maskArray);
        DefaultGradient gradient = new DefaultGradient();
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        Nd4j.gemm((INDArray)this.input, (INDArray)delta, (INDArray)weightGradView, (boolean)true, (boolean)false, (double)1.0, (double)0.0);
        delta.sum(biasGradView, new int[]{0});
        gradient.gradientForVariable().put("W", weightGradView);
        gradient.gradientForVariable().put("b", biasGradView);
        return new Pair<Gradient, INDArray>(gradient, delta);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.output(training);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.output(true);
    }

    @Override
    public INDArray activate() {
        return this.output(false);
    }

    public INDArray output(INDArray input, boolean training) {
        this.setInput(input);
        return this.output(training);
    }

    public INDArray output(INDArray input) {
        this.setInput(input);
        return this.output(false);
    }

    public INDArray output(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("Cannot perform forward pass with null input - " + this.layerId());
        }
        return super.activate(training);
    }

    @Override
    public double f1Score(DataSet data) {
        return this.f1Score(data.getFeatures(), data.getLabels());
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(examples));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        while (iter.hasNext()) {
            this.fit((DataSet)iter.next());
        }
    }

    @Override
    public int[] predict(INDArray input) {
        INDArray output = this.output(input);
        int[] ret = new int[input.rows()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow(i));
        }
        return ret;
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        int[] intRet = this.predict(dataSet.getFeatures());
        ArrayList<String> ret = new ArrayList<String>();
        for (int i : intRet) {
            ret.add(i, dataSet.getLabelName(i));
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        return this.output(examples);
    }

    @Override
    public void fit(INDArray input, INDArray labels) {
        this.setInput(input);
        this.setLabels(labels);
        this.applyDropOutIfNecessary(true);
        if (this.solver == null) {
            this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
            Updater updater = this.solver.getOptimizer().getUpdater();
            int updaterStateSize = 0;
            Map<String, INDArray> paramTable = this.paramTable();
            for (Map.Entry<String, INDArray> entry : paramTable.entrySet()) {
                updaterStateSize += (int)this.conf().getLayer().getIUpdaterByParam(entry.getKey()).stateSize((long)entry.getValue().length());
            }
            if (updaterStateSize > 0) {
                updater.setStateViewArray(this, Nd4j.createUninitialized((int[])new int[]{1, updaterStateSize}, (char)Nd4j.order().charValue()), true);
            }
        }
        this.solver.optimize();
    }

    @Override
    public void fit(DataSet data) {
        this.fit(data.getFeatures(), data.getLabels());
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        INDArray outcomeMatrix = FeatureUtil.toOutcomeMatrix((int[])labels, (int)this.numLabels());
        this.fit(examples, outcomeMatrix);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labels != null) {
            this.labels.data().destroy();
            this.labels = null;
        }
        this.solver = null;
    }

    @Override
    public void fit(INDArray data) {
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    protected INDArray preOutput2d(boolean training) {
        return this.preOutput(training);
    }

    @Override
    protected void applyMask(INDArray to) {
        if (this.maskArray.isColumnVector()) {
            to.muliColumnVector(this.maskArray);
        } else if (Arrays.equals(to.shape(), this.maskArray.shape())) {
            to.muli(this.maskArray);
        } else {
            throw new IllegalStateException("Invalid mask array: per-example masking should be a column vector, per output masking arrays should be the same shape as the output/labels arrays. Mask shape: " + Arrays.toString(this.maskArray.shape()) + ", output shape: " + Arrays.toString(to.shape()) + this.layerId());
        }
    }

    protected INDArray getLabels2d() {
        if (this.labels.rank() > 2) {
            return this.labels.reshape(this.labels.size(2), this.labels.size(1));
        }
        return this.labels;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }
}

