/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class StackVertex
extends BaseGraphVertex {
    private int[][] lastInputShapes;

    public StackVertex(ComputationGraph graph, String name, int vertexIndex) {
        this(graph, name, vertexIndex, null, null);
    }

    public StackVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        this.lastInputShapes = null;
        int nStack = this.inputs.length;
        int[] inShape = this.inputs[0].shape();
        int[] outShape = new int[inShape.length];
        outShape[0] = nStack * inShape[0];
        for (int i = 1; i < inShape.length; ++i) {
            outShape[i] = inShape[i];
        }
        boolean variableLengthTS = false;
        if (inShape.length == 3) {
            int minLength;
            int maxLength = minLength = this.inputs[0].size(2);
            for (int i = 1; i < this.inputs.length; ++i) {
                int thisLength = this.inputs[i].size(2);
                minLength = Math.min(minLength, thisLength);
                maxLength = Math.max(maxLength, thisLength);
            }
            boolean bl = variableLengthTS = minLength != maxLength;
            if (!variableLengthTS) {
                return Nd4j.concat((int)0, (INDArray[])this.inputs);
            }
            outShape[2] = maxLength;
            INDArray out = Nd4j.create((int[])outShape);
            int numExamples = this.inputs[0].size(0);
            this.lastInputShapes = new int[this.inputs.length][0];
            for (int i = 0; i < this.inputs.length; ++i) {
                out.put(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * numExamples), (int)((i + 1) * numExamples)), NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)this.inputs[i].size(2))}, this.inputs[i]);
                this.lastInputShapes[i] = this.inputs[i].shape();
            }
            return out;
        }
        return Nd4j.concat((int)0, (INDArray[])this.inputs);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        if (this.epsilon == null) {
            return new Pair<Object, INDArray[]>(null, new INDArray[this.inputs.length]);
        }
        int nStack = this.inputs.length;
        INDArray[] out = new INDArray[nStack];
        int step = this.epsilon.size(0) / nStack;
        block5: for (int i = 0; i < nStack; ++i) {
            switch (this.epsilon.rank()) {
                case 2: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all()});
                    continue block5;
                }
                case 3: {
                    if (this.lastInputShapes != null) {
                        out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)this.lastInputShapes[i][2])});
                        continue block5;
                    }
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                case 4: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot get subset for activations of rank " + this.inputs[0].rank());
                }
            }
        }
        return new Pair<Object, INDArray[]>(null, out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        int size1_ex0;
        if (maskArrays == null) {
            return new Pair<Object, MaskState>(null, currentMaskState);
        }
        boolean allSameLength = true;
        int maxLength = size1_ex0 = maskArrays[0].size(1);
        for (int i = 1; i < maskArrays.length; ++i) {
            allSameLength &= size1_ex0 == maskArrays[i].size(1);
            maxLength = Math.max(maxLength, maskArrays[i].size(1));
        }
        if (allSameLength) {
            return new Pair<INDArray, MaskState>(Nd4j.vstack((INDArray[])maskArrays), currentMaskState);
        }
        int numExamples = maskArrays[0].size(0);
        INDArray outMask = Nd4j.create((int)(maskArrays.length * numExamples), (int)maxLength);
        for (int i = 0; i < maskArrays.length; ++i) {
            outMask.put(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * numExamples), (int)((i + 1) * numExamples)), NDArrayIndex.interval((int)0, (int)maskArrays[i].size(1))}, maskArrays[i]);
        }
        return new Pair<INDArray, MaskState>(outMask, currentMaskState);
    }

    @Override
    public String toString() {
        return "StackVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ")";
    }
}

