/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class L2Vertex
extends BaseGraphVertex {
    private double eps;

    public L2Vertex(ComputationGraph graph, String name, int vertexIndex, double eps) {
        this(graph, name, vertexIndex, null, null, eps);
    }

    public L2Vertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, double eps) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.eps = eps;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        INDArray a = this.inputs[0];
        INDArray b = this.inputs[1];
        int[] dimensions = new int[a.rank() - 1];
        for (int i = 1; i < a.rank(); ++i) {
            dimensions[i - 1] = i;
        }
        return Nd4j.getExecutioner().exec((Accumulation)new EuclideanDistance(a, b), dimensions);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        INDArray dLdb;
        INDArray dLda;
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: error not set");
        }
        INDArray a = this.inputs[0];
        INDArray b = this.inputs[1];
        INDArray out = this.doForward(tbptt);
        Transforms.max((INDArray)out, (double)this.eps, (boolean)false);
        INDArray dLdlambda = this.epsilon;
        INDArray sNegHalf = out.rdiv((Number)1.0);
        INDArray diff = a.sub(b);
        INDArray first = dLdlambda.mul(sNegHalf);
        if (a.rank() == 2) {
            dLda = diff.muliColumnVector(first);
            dLdb = dLda.neg();
        } else {
            dLda = Nd4j.getExecutioner().execAndReturn((BroadcastOp)new BroadcastMulOp(diff, first, diff, new int[]{0}));
            dLdb = dLda.neg();
        }
        return new Pair<Object, INDArray[]>(null, new INDArray[]{dLda, dLdb});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public String toString() {
        return "L2Vertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ")";
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair<INDArray, MaskState>(maskArrays[0], currentMaskState);
    }
}

