/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.eval;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.eval.EvaluationUtils;
import org.deeplearning4j.eval.IEvaluation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;

public abstract class BaseEvaluation<T extends BaseEvaluation>
implements IEvaluation<T> {
    private static ObjectMapper objectMapper = BaseEvaluation.configureMapper(new ObjectMapper());
    private static ObjectMapper yamlMapper = BaseEvaluation.configureMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));

    private static ObjectMapper configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        ret.setVisibilityChecker(ret.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return ret;
    }

    @Override
    public void evalTimeSeries(INDArray labels, INDArray predicted) {
        this.evalTimeSeries(labels, predicted, null);
    }

    @Override
    public void evalTimeSeries(INDArray labels, INDArray predictions, INDArray labelsMask) {
        Pair<INDArray, INDArray> pair = EvaluationUtils.extractNonMaskedTimeSteps(labels, predictions, labelsMask);
        INDArray labels2d = pair.getFirst();
        INDArray predicted2d = pair.getSecond();
        this.eval(labels2d, predicted2d);
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, List<? extends Serializable> recordMetaData) {
        this.eval(labels, networkPredictions);
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, INDArray maskArray) {
        if (maskArray == null) {
            if (labels.rank() == 3) {
                this.evalTimeSeries(labels, networkPredictions, maskArray);
            } else {
                this.eval(labels, networkPredictions);
            }
            return;
        }
        if (labels.rank() == 3 && maskArray.rank() == 2) {
            this.evalTimeSeries(labels, networkPredictions, maskArray);
            return;
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support per-output masking");
    }

    @Override
    public String toJson() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toYaml() {
        try {
            return yamlMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IEvaluation> T fromYaml(String yaml, Class<T> clazz) {
        try {
            return (T)((IEvaluation)yamlMapper.readValue(yaml, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IEvaluation> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)((IEvaluation)objectMapper.readValue(json, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.stats();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEvaluation)) {
            return false;
        }
        BaseEvaluation other = (BaseEvaluation)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEvaluation;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectMapper getYamlMapper() {
        return yamlMapper;
    }
}

