/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class StackVertex
extends BaseGraphVertex {
    public StackVertex(ComputationGraph graph, String name, int vertexIndex) {
        this(graph, name, vertexIndex, null, null);
    }

    public StackVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        int nStack = this.inputs.length;
        int[] inShape = this.inputs[0].shape();
        int[] outShape = new int[inShape.length];
        for (int i = 0; i < inShape.length; ++i) {
            if (i == 0) {
                outShape[0] = nStack * inShape[0];
                continue;
            }
            outShape[i] = inShape[i];
        }
        INDArray out = Nd4j.create((int[])outShape);
        INDArrayIndex[] indexes = new INDArrayIndex[inShape.length];
        for (int i = 0; i < inShape.length; ++i) {
            indexes[i] = NDArrayIndex.all();
        }
        int rowCount = 0;
        for (INDArray input : this.inputs) {
            int nEx = input.size(0);
            indexes[0] = NDArrayIndex.interval((int)rowCount, (int)(rowCount + nEx));
            out.put(indexes, input);
            rowCount += nEx;
        }
        return out;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        int nStack = this.inputs.length;
        INDArray[] out = new INDArray[nStack];
        int step = this.epsilon.size(0) / nStack;
        block5: for (int i = 0; i < nStack; ++i) {
            switch (this.epsilon.rank()) {
                case 2: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all()});
                    continue block5;
                }
                case 3: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                case 4: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * step), (int)((i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot get subset for activations of rank " + this.inputs[0].rank());
                }
            }
        }
        return new Pair<Object, INDArray[]>(null, out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null) {
            return new Pair<Object, MaskState>(null, currentMaskState);
        }
        return new Pair<INDArray, MaskState>(Nd4j.vstack((INDArray[])maskArrays), currentMaskState);
    }

    @Override
    public String toString() {
        return "StackVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ")";
    }
}

