/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.setup;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.preprocessor.CnnToFeedForwardPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.RnnToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.RnnToFeedForwardPreProcessor;
import org.deeplearning4j.nn.layers.convolution.KernelValidationUtil;

@Deprecated
public class ConvolutionLayerSetup {
    public static final String CONVOLUTION_LAYER = "ConvolutionLayer";
    public static final String LOCAL_RESPONSE_NORMALIZATION = "LocalResponseNormalization";
    public static final String SUBSAMPLING_LAYER = "SubsamplingLayer";
    public static final String RECURSIVE_AUTO_ENCODER = "RecursiveAutoEncoder";
    public static final String RBM = "RBM";
    public static final String DENSE_LAYER = "DenseLayer";
    public static final String OUTPUT_LAYER = "OutputLayer";
    public static final String GRAVES_LSTM = "GravesLSTM";
    public static final String GRAVES_BIDIRECTIONAL_LSTM = "GravesBidirectionalLSTM";
    public static final String RNN_OUTPUT_LAYER = "RnnOutputLayer";
    public static final String ACTIVATION_LAYER = "ActivationLayer";
    public static final String BATCH_NORMALIZATION = "BatchNormalization";
    protected int lastHeight = -1;
    protected int lastWidth = -1;
    protected int lastOutChannels = -1;
    protected int lastnOut = -1;
    protected int numLayers = -1;
    protected String inLayerName;
    protected String outLayerName;
    protected Map<String, int[]> nOutsPerLayer = new HashMap<String, int[]>();
    protected Map<String, Integer> nInsPerLayer = new HashMap<String, Integer>();
    protected MultiLayerConfiguration.Builder conf;
    protected boolean useCNN = true;

    @Deprecated
    public ConvolutionLayerSetup(MultiLayerConfiguration.Builder builder, int height, int width, int channels) {
        this.conf = builder;
        this.lastHeight = height;
        this.lastWidth = width;
        this.lastOutChannels = channels;
        if (this.conf instanceof NeuralNetConfiguration.ListBuilder) {
            NeuralNetConfiguration.ListBuilder listBuilder = (NeuralNetConfiguration.ListBuilder)this.conf;
            this.numLayers = listBuilder.getLayerwise().size();
        } else {
            this.numLayers = this.conf.getConfs().size();
        }
        for (int i = 0; i < this.numLayers - 1; ++i) {
            Layer inputLayer = this.getLayer(i, this.conf);
            Layer outputLayer = this.getLayer(i + 1, this.conf);
            this.updateLayerInputs(i, inputLayer, outputLayer);
        }
    }

    private void storeNInAndNOut(String inName, int out) {
        this.nInsPerLayer.put(inName, out);
        this.nOutsPerLayer.put(this.inLayerName, new int[]{this.lastHeight, this.lastWidth, this.lastOutChannels});
    }

    private void updateLayerInputs(int i, Layer inputLayer, Layer outputLayer) {
        int lastLayerNumber = this.numLayers - 1;
        this.inLayerName = inputLayer.getLayerName() != null ? inputLayer.getLayerName() : Integer.toString(i);
        String string = this.outLayerName = outputLayer.getLayerName() != null ? outputLayer.getLayerName() : Integer.toString(i + 1);
        if (i < lastLayerNumber) {
            block14 : switch (inputLayer.getClass().getSimpleName()) {
                case "ConvolutionLayer": {
                    ConvolutionLayer convolutionLayer = (ConvolutionLayer)inputLayer;
                    if (i == 0) {
                        this.conf.inputPreProcessor(i, new FeedForwardToCnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                        this.lastnOut = convolutionLayer.getNOut();
                        convolutionLayer.setNIn(this.lastOutChannels);
                    }
                    this.getConvolutionOutputSize(new int[]{this.lastHeight, this.lastWidth}, convolutionLayer.getKernelSize(), convolutionLayer.getPadding(), convolutionLayer.getStride());
                    this.lastOutChannels = convolutionLayer.getNOut();
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer nextConv = (ConvolutionLayer)outputLayer;
                            this.lastOutChannels = this.lastnOut = convolutionLayer.getNOut();
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            nextConv.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "LocalResponseNormalization": 
                        case "SubsamplingLayer": {
                            this.lastOutChannels = this.lastnOut = convolutionLayer.getNOut();
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastOutChannels = convolutionLayer.getNOut();
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToFeedForwardPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToRnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "ActivationLayer": {
                            ActivationLayer feedForwardLayer = (ActivationLayer)outputLayer;
                            this.lastOutChannels = this.lastnOut = convolutionLayer.getNOut();
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            feedForwardLayer.setNOut(this.lastnOut);
                            this.useCNN = true;
                            break block14;
                        }
                        case "BatchNormalization": {
                            BatchNormalization feedForwardLayer = (BatchNormalization)outputLayer;
                            this.lastOutChannels = this.lastnOut = convolutionLayer.getNOut();
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            feedForwardLayer.setNOut(this.lastnOut);
                            this.useCNN = true;
                        }
                    }
                    break;
                }
                case "SubsamplingLayer": {
                    SubsamplingLayer subsamplingLayer = (SubsamplingLayer)inputLayer;
                    this.getConvolutionOutputSize(new int[]{this.lastHeight, this.lastWidth}, subsamplingLayer.getKernelSize(), subsamplingLayer.getPadding(), subsamplingLayer.getStride());
                    if (i == 0) {
                        throw new UnsupportedOperationException("Unsupported path: first layer shouldn't be " + this.inLayerName);
                    }
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer nextConv = (ConvolutionLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastOutChannels);
                            nextConv.setNIn(this.lastOutChannels);
                            break block14;
                        }
                        case "SubsamplingLayer": {
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToFeedForwardPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToRnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "ActivationLayer": 
                        case "BatchNormalization": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            feedForwardLayer.setNOut(this.lastnOut);
                            this.useCNN = true;
                        }
                    }
                    break;
                }
                case "GravesLSTM": 
                case "GravesBidirectionalLSTM": {
                    if (i == 0) {
                        throw new UnsupportedOperationException("Apply nIn attribute to the layer configuration for " + this.inLayerName);
                    }
                    FeedForwardLayer feedForwardLayer = (FeedForwardLayer)inputLayer;
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer convolutionLayer = (ConvolutionLayer)outputLayer;
                            this.conf.inputPreProcessor(i, new RnnToCnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            this.lastnOut = convolutionLayer.getNOut();
                            convolutionLayer.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "SubsamplingLayer": {
                            throw new UnsupportedOperationException("Subsampling Layer should be connected to Convolution, LocalResponseNormalization or BatchNormalization Layer");
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new RnnToFeedForwardPreProcessor());
                            break block14;
                        }
                        case "BatchNormalization": {
                            throw new UnsupportedOperationException("Currently not implemented for " + this.inLayerName);
                        }
                        case "ActivationLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNOut(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new RnnToFeedForwardPreProcessor());
                            this.useCNN = false;
                        }
                    }
                    break;
                }
                case "RecursiveAutoEncoder": 
                case "RBM": 
                case "DenseLayer": {
                    if (i == 0) {
                        throw new UnsupportedOperationException("Apply nIn attribute to the layer configuration for " + this.inLayerName);
                    }
                    FeedForwardLayer feedForwardLayer = (FeedForwardLayer)inputLayer;
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer convolutionLayer = (ConvolutionLayer)outputLayer;
                            this.conf.inputPreProcessor(i + 1, new FeedForwardToCnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            this.lastnOut = this.lastOutChannels;
                            convolutionLayer.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "SubsamplingLayer": {
                            this.conf.inputPreProcessor(i + 1, new FeedForwardToCnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            this.lastnOut = this.lastOutChannels;
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new FeedForwardToRnnPreProcessor());
                            break block14;
                        }
                        case "BatchNormalization": {
                            BatchNormalization bnLayer = (BatchNormalization)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.lastHeight = 1;
                            this.lastWidth = 1;
                            this.lastOutChannels = this.lastnOut;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            bnLayer.setNOut(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new FeedForwardToCnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "ActivationLayer": {
                            FeedForwardLayer feedForwardLayer2 = (FeedForwardLayer)outputLayer;
                            this.lastnOut = feedForwardLayer.getNOut();
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer2.setNOut(this.lastnOut);
                            this.useCNN = false;
                        }
                    }
                    break;
                }
                case "ActivationLayer": 
                case "BatchNormalization": {
                    if (i == 0) {
                        throw new UnsupportedOperationException("Unsupported path: first layer shouldn't be " + this.inLayerName);
                    }
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer convolutionLayer = (ConvolutionLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastOutChannels);
                            convolutionLayer.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "SubsamplingLayer": {
                            this.storeNInAndNOut(this.inLayerName, this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToFeedForwardPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            if (this.useCNN) {
                                FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                                this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                                this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                                feedForwardLayer.setNIn(this.lastnOut);
                                this.conf.inputPreProcessor(i + 1, new CnnToRnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                                break block14;
                            }
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new FeedForwardToRnnPreProcessor());
                            break block14;
                        }
                        case "BatchNormalization": 
                        case "ActivationLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNOut(this.lastnOut);
                            break block14;
                        }
                        case "LocalResponseNormalization": {
                            throw new UnsupportedOperationException("LocalResponse should not follow " + this.inLayerName);
                        }
                    }
                    break;
                }
                case "LocalResponseNormalization": {
                    if (i == 0) {
                        throw new UnsupportedOperationException("Unsupported path: first layer shouldn't be " + this.inLayerName);
                    }
                    switch (outputLayer.getClass().getSimpleName()) {
                        case "ConvolutionLayer": {
                            ConvolutionLayer nextConv = (ConvolutionLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastOutChannels);
                            nextConv.setNIn(this.lastnOut);
                            break block14;
                        }
                        case "RecursiveAutoEncoder": 
                        case "RBM": 
                        case "DenseLayer": 
                        case "OutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToFeedForwardPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "GravesLSTM": 
                        case "GravesBidirectionalLSTM": 
                        case "RnnOutputLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.lastnOut = this.lastHeight * this.lastWidth * this.lastOutChannels;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNIn(this.lastnOut);
                            this.conf.inputPreProcessor(i + 1, new CnnToRnnPreProcessor(this.lastHeight, this.lastWidth, this.lastOutChannels));
                            break block14;
                        }
                        case "BatchNormalization": {
                            throw new UnsupportedOperationException("BaseNormalization should not follow a LocalResponse layer.");
                        }
                        case "ActivationLayer": {
                            FeedForwardLayer feedForwardLayer = (FeedForwardLayer)outputLayer;
                            this.storeNInAndNOut(this.outLayerName, this.lastnOut);
                            feedForwardLayer.setNOut(this.lastnOut);
                            this.useCNN = true;
                        }
                    }
                    break;
                }
                case "RnnOutputLayer": 
                case "OutputLayer": {
                    throw new UnsupportedOperationException("OutputLayer should be the last layer");
                }
            }
        } else {
            throw new UnsupportedOperationException("Unsupported path: final " + inputLayer.getClass().getSimpleName() + " layer");
        }
    }

    private void getConvolutionOutputSize(int[] input, int[] kernel, int[] padding, int[] stride) {
        int[] ret = new int[input.length];
        KernelValidationUtil.validateShapes(input[0], input[1], kernel[0], kernel[1], stride[0], stride[1], padding[0], padding[1]);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (input[i] - kernel[i] + 2 * padding[i]) / stride[i] + 1;
        }
        this.lastHeight = ret[0];
        this.lastWidth = ret[1];
    }

    public Layer getLayer(int i, MultiLayerConfiguration.Builder builder) {
        if (builder instanceof NeuralNetConfiguration.ListBuilder) {
            NeuralNetConfiguration.ListBuilder listBuilder = (NeuralNetConfiguration.ListBuilder)builder;
            if (listBuilder.getLayerwise().get(i) == null) {
                throw new IllegalStateException("Undefined layer " + i);
            }
            return listBuilder.getLayerwise().get(i).getLayer();
        }
        return builder.getConfs().get(i).getLayer();
    }

    public int getLastHeight() {
        return this.lastHeight;
    }

    public void setLastHeight(int lastHeight) {
        this.lastHeight = lastHeight;
    }

    public int getLastWidth() {
        return this.lastWidth;
    }

    public void setLastWidth(int lastWidth) {
        this.lastWidth = lastWidth;
    }

    public int getLastOutChannels() {
        return this.lastOutChannels;
    }

    public void setLastOutChannels(int lastOutChannels) {
        this.lastOutChannels = lastOutChannels;
    }

    public Map<String, int[]> getOutSizesEachLayer() {
        return this.nOutsPerLayer;
    }

    public void setOutSizesEachLayer(Map<String, int[]> outSizesEachLayer) {
        this.nOutsPerLayer = outSizesEachLayer;
    }

    public Map<String, Integer> getnInForLayer() {
        return this.nInsPerLayer;
    }

    public void setnInForLayer(Map<String, Integer> nInForLayer) {
        this.nInsPerLayer = nInForLayer;
    }
}

