/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.inputs;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InputTypeFeedForward.class, name="FeedForward"), @JsonSubTypes.Type(value=InputTypeRecurrent.class, name="Recurrent"), @JsonSubTypes.Type(value=InputTypeConvolutional.class, name="Convolutional"), @JsonSubTypes.Type(value=InputTypeConvolutionalFlat.class, name="ConvolutionalFlat")})
public abstract class InputType
implements Serializable {
    public abstract Type getType();

    public abstract String toString();

    public static InputType feedForward(int size) {
        return new InputTypeFeedForward(size);
    }

    public static InputType recurrent(int size) {
        return new InputTypeRecurrent(size);
    }

    public static InputType convolutional(int height, int width, int depth) {
        return new InputTypeConvolutional(height, width, depth);
    }

    public static InputType convolutionalFlat(int height, int width, int depth) {
        return new InputTypeConvolutionalFlat(height, width, depth);
    }

    public static class InputTypeConvolutionalFlat
    extends InputType {
        private int height;
        private int width;
        private int depth;

        @Override
        public Type getType() {
            return Type.CNNFlat;
        }

        public int getFlattenedSize() {
            return this.height * this.width * this.depth;
        }

        public InputType getUnflattenedType() {
            return InputType.convolutional(this.height, this.width, this.depth);
        }

        @Override
        public String toString() {
            return "InputTypeConvolutionalFlat(h=" + this.height + ",w=" + this.width + ",d=" + this.depth + ")";
        }

        @ConstructorProperties(value={"height", "width", "depth"})
        public InputTypeConvolutionalFlat(int height, int width, int depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutionalFlat)) {
                return false;
            }
            InputTypeConvolutionalFlat other = (InputTypeConvolutionalFlat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutionalFlat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getDepth();
            return result;
        }

        public InputTypeConvolutionalFlat() {
        }
    }

    public static class InputTypeConvolutional
    extends InputType {
        private int height;
        private int width;
        private int depth;

        @Override
        public Type getType() {
            return Type.CNN;
        }

        @Override
        public String toString() {
            return "InputTypeConvolutional(h=" + this.height + ",w=" + this.width + ",d=" + this.depth + ")";
        }

        @ConstructorProperties(value={"height", "width", "depth"})
        public InputTypeConvolutional(int height, int width, int depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutional)) {
                return false;
            }
            InputTypeConvolutional other = (InputTypeConvolutional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getDepth();
            return result;
        }

        public InputTypeConvolutional() {
        }
    }

    public static class InputTypeRecurrent
    extends InputType {
        private int size;

        @Override
        public Type getType() {
            return Type.RNN;
        }

        @Override
        public String toString() {
            return "InputTypeRecurrent(" + this.size + ")";
        }

        @ConstructorProperties(value={"size"})
        public InputTypeRecurrent(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public InputTypeRecurrent() {
        }
    }

    public static class InputTypeFeedForward
    extends InputType {
        private int size;

        @Override
        public Type getType() {
            return Type.FF;
        }

        @Override
        public String toString() {
            return "InputTypeFeedForward(" + this.size + ")";
        }

        @ConstructorProperties(value={"size"})
        public InputTypeFeedForward(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public InputTypeFeedForward() {
        }
    }

    public static enum Type {
        FF,
        RNN,
        CNN,
        CNNFlat;

    }
}

