/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ActivationLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.ActivationLayer> {
    public ActivationLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public ActivationLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2() {
        return 0.0;
    }

    @Override
    public double calcL1() {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray activationDerivative = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), this.input).derivative());
        INDArray delta = epsilon.muli(activationDerivative);
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray);
        }
        DefaultGradient ret = new DefaultGradient();
        return new Pair<Gradient, INDArray>(ret, delta);
    }

    @Override
    public INDArray activate(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        this.applyDropOutIfNecessary(training);
        INDArray in = training ? this.input.dup() : this.input;
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), in));
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray params() {
        return null;
    }
}

