/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class UnstackVertex
extends BaseGraphVertex {
    private int from;
    private int stackSize;
    private int[] forwardShape;
    private int step;

    public UnstackVertex(ComputationGraph graph, String name, int vertexIndex, int from, int stackSize) {
        this(graph, name, vertexIndex, null, null, from, stackSize);
    }

    public UnstackVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, int from, int stackSize) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.from = from;
        this.stackSize = stackSize;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        this.forwardShape = Arrays.copyOf(this.inputs[0].shape(), this.inputs[0].rank());
        this.step = this.inputs[0].size(0) / this.stackSize;
        int start = this.from * this.step;
        int end = (this.from + 1) * this.step;
        switch (this.inputs[0].rank()) {
            case 2: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all()}).dup();
            }
            case 3: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all(), NDArrayIndex.all()}).dup();
            }
            case 4: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}).dup();
            }
        }
        throw new UnsupportedOperationException("Cannot get subset for activations of rank " + this.inputs[0].rank());
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: error not set");
        }
        INDArray out = Nd4j.zeros((int[])this.forwardShape);
        int start = this.from * this.step;
        int end = (this.from + 1) * this.step;
        switch (this.forwardShape.length) {
            case 2: {
                out.put(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all()}, this.epsilon);
                break;
            }
            case 3: {
                out.put(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all(), NDArrayIndex.all()}, this.epsilon);
                break;
            }
            case 4: {
                out.put(new INDArrayIndex[]{NDArrayIndex.interval((int)start, (int)end), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}, this.epsilon);
                break;
            }
            default: {
                throw new RuntimeException("Invalid activation rank");
            }
        }
        return new Pair<Object, INDArray[]>(null, new INDArray[]{out});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public String toString() {
        return "UnstackVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",fromIdx=" + this.from + ",forwardShape=" + this.forwardShape + ")";
    }
}

