/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex;

import java.util.Arrays;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.GraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseGraphVertex
implements GraphVertex {
    protected ComputationGraph graph;
    protected String vertexName;
    protected int vertexIndex;
    protected VertexIndices[] inputVertices;
    protected VertexIndices[] outputVertices;
    protected INDArray[] inputs;
    protected INDArray epsilon;

    protected BaseGraphVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices) {
        this.graph = graph;
        this.vertexName = name;
        this.vertexIndex = vertexIndex;
        this.inputVertices = inputVertices;
        this.outputVertices = outputVertices;
        this.inputs = new INDArray[inputVertices != null ? inputVertices.length : 0];
    }

    @Override
    public String getVertexName() {
        return this.vertexName;
    }

    @Override
    public int getVertexIndex() {
        return this.vertexIndex;
    }

    @Override
    public int getNumInputArrays() {
        return this.inputVertices == null ? 0 : this.inputVertices.length;
    }

    @Override
    public int getNumOutputConnections() {
        return this.outputVertices == null ? 0 : this.outputVertices.length;
    }

    @Override
    public VertexIndices[] getInputVertices() {
        return this.inputVertices;
    }

    @Override
    public void setInputVertices(VertexIndices[] inputVertices) {
        this.inputVertices = inputVertices;
        this.inputs = new INDArray[inputVertices != null ? inputVertices.length : 0];
    }

    @Override
    public VertexIndices[] getOutputVertices() {
        return this.outputVertices;
    }

    @Override
    public void setOutputVertices(VertexIndices[] outputVertices) {
        this.outputVertices = outputVertices;
    }

    @Override
    public boolean isInputVertex() {
        return false;
    }

    @Override
    public void setInput(int inputNumber, INDArray input) {
        if (inputNumber >= this.getNumInputArrays()) {
            throw new IllegalArgumentException("Invalid input number");
        }
        this.inputs[inputNumber] = input;
    }

    @Override
    public void setError(int errorNumber, INDArray error) {
        this.epsilon = error;
    }

    @Override
    public void setEpsilon(INDArray epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = null;
        }
    }

    @Override
    public boolean canDoForward() {
        for (INDArray input : this.inputs) {
            if (input != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDoBackward() {
        for (INDArray input : this.inputs) {
            if (input != null) continue;
            return false;
        }
        return this.epsilon != null;
    }

    @Override
    public INDArray[] getErrors() {
        return new INDArray[]{this.epsilon};
    }

    @Override
    public void setErrors(INDArray ... errors) {
        this.epsilon = errors[0];
    }

    @Override
    public INDArray getEpsilon() {
        return this.epsilon;
    }

    public abstract String toString();

    public ComputationGraph getGraph() {
        return this.graph;
    }

    @Override
    public INDArray[] getInputs() {
        return this.inputs;
    }

    public void setGraph(ComputationGraph graph) {
        this.graph = graph;
    }

    public void setVertexName(String vertexName) {
        this.vertexName = vertexName;
    }

    public void setVertexIndex(int vertexIndex) {
        this.vertexIndex = vertexIndex;
    }

    @Override
    public void setInputs(INDArray[] inputs) {
        this.inputs = inputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseGraphVertex)) {
            return false;
        }
        BaseGraphVertex other = (BaseGraphVertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComputationGraph this$graph = this.getGraph();
        ComputationGraph other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        String this$vertexName = this.getVertexName();
        String other$vertexName = other.getVertexName();
        if (this$vertexName == null ? other$vertexName != null : !this$vertexName.equals(other$vertexName)) {
            return false;
        }
        if (this.getVertexIndex() != other.getVertexIndex()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputVertices(), other.getInputVertices())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutputVertices(), other.getOutputVertices())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
            return false;
        }
        INDArray this$epsilon = this.getEpsilon();
        INDArray other$epsilon = other.getEpsilon();
        return !(this$epsilon == null ? other$epsilon != null : !this$epsilon.equals(other$epsilon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseGraphVertex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComputationGraph $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        String $vertexName = this.getVertexName();
        result = result * 59 + ($vertexName == null ? 43 : $vertexName.hashCode());
        result = result * 59 + this.getVertexIndex();
        result = result * 59 + Arrays.deepHashCode(this.getInputVertices());
        result = result * 59 + Arrays.deepHashCode(this.getOutputVertices());
        result = result * 59 + Arrays.deepHashCode(this.getInputs());
        INDArray $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : $epsilon.hashCode());
        return result;
    }
}

