/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.params.ConvolutionParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.LayerValidation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.Convolution;

public class ConvolutionLayer
extends FeedForwardLayer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected AlgoMode cudnnAlgoMode = AlgoMode.PREFER_FASTEST;

    private ConvolutionLayer(Builder builder) {
        super(builder);
        this.convolutionMode = builder.convolutionMode;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Stride should include stride for rows and columns (a 2d array)");
        }
        this.stride = builder.stride;
        if (builder.padding.length != 2) {
            throw new IllegalArgumentException("Padding should include padding for rows and columns (a 2d array)");
        }
        this.padding = builder.padding;
        this.cudnnAlgoMode = builder.cudnnAlgoMode;
    }

    @Override
    public ConvolutionLayer clone() {
        ConvolutionLayer clone = (ConvolutionLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("ConvolutionLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.convolution.ConvolutionLayer ret = new org.deeplearning4j.nn.layers.convolution.ConvolutionLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return ConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), ConvolutionLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        if (this.nIn <= 0 || override) {
            InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
            this.nIn = c.getDepth();
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public AlgoMode getCudnnAlgoMode() {
        return this.cudnnAlgoMode;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setCudnnAlgoMode(AlgoMode cudnnAlgoMode) {
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public ConvolutionLayer() {
    }

    @Override
    public String toString() {
        return "ConvolutionLayer(super=" + super.toString() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", cudnnAlgoMode=" + (Object)((Object)this.getCudnnAlgoMode()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionLayer)) {
            return false;
        }
        ConvolutionLayer other = (ConvolutionLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
        AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
        return !(this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
        result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private ConvolutionMode convolutionMode = null;
        private int[] kernelSize = new int[]{5, 5};
        private int[] stride = new int[]{1, 1};
        private int[] padding = new int[]{0, 0};
        private AlgoMode cudnnAlgoMode = AlgoMode.PREFER_FASTEST;

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        public Builder(int[] kernelSize, int[] stride) {
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        public Builder(int ... kernelSize) {
            this.kernelSize = kernelSize;
        }

        public Builder() {
        }

        @Deprecated
        public Builder convolutionType(Convolution.Type convolutionType) {
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            this.padding = padding;
            return this;
        }

        public Builder cudnnAlgoMode(AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            return this;
        }

        @Override
        public ConvolutionLayer build() {
            return new ConvolutionLayer(this);
        }

        @ConstructorProperties(value={"convolutionMode", "kernelSize", "stride", "padding", "cudnnAlgoMode"})
        public Builder(ConvolutionMode convolutionMode, int[] kernelSize, int[] stride, int[] padding, AlgoMode cudnnAlgoMode) {
            this.convolutionMode = convolutionMode;
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
            this.cudnnAlgoMode = cudnnAlgoMode;
        }
    }

    public static enum AlgoMode {
        NO_WORKSPACE,
        PREFER_FASTEST;

    }
}

