/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ElementWiseVertex
extends GraphVertex {
    protected Op op;

    public ElementWiseVertex(@JsonProperty(value="op") Op op) {
        this.op = op;
    }

    @Override
    public ElementWiseVertex clone() {
        return new ElementWiseVertex(this.op);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ElementWiseVertex)) {
            return false;
        }
        return ((ElementWiseVertex)o).op == this.op;
    }

    @Override
    public int hashCode() {
        return this.op.hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        ElementWiseVertex.Op op;
        switch (this.op) {
            case Add: {
                op = ElementWiseVertex.Op.Add;
                break;
            }
            case Subtract: {
                op = ElementWiseVertex.Op.Subtract;
                break;
            }
            case Product: {
                op = ElementWiseVertex.Op.Product;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return new org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex(graph, name, idx, op);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        if (first.getType() != InputType.Type.CNN) {
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() == first.getType()) continue;
                throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
        } else {
            InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
            int fd = firstConv.getDepth();
            int fw = firstConv.getWidth();
            int fh = firstConv.getHeight();
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() != InputType.Type.CNN) {
                    throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
                int od = otherConv.getDepth();
                int ow = otherConv.getWidth();
                int oh = otherConv.getHeight();
                if (fd == od && fw == ow && fh == oh) continue;
                throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process CNN activations of different sizes:first [depth,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
        }
        return first;
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public String toString() {
        return "ElementWiseVertex(op=" + (Object)((Object)this.getOp()) + ")";
    }

    public static enum Op {
        Add,
        Subtract,
        Product;

    }
}

