/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.Triple;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.optimize.Solver;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.util.FeatureUtil;

public abstract class BaseOutputLayer<LayerConfT extends org.deeplearning4j.nn.conf.layers.BaseOutputLayer>
extends BaseLayer<LayerConfT>
implements Serializable,
IOutputLayer {
    protected INDArray labels;
    private transient Solver solver;
    private transient ILossFunction lossFunction;
    private double fullNetworkL1;
    private double fullNetworkL2;

    public BaseOutputLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseOutputLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double computeScore(double fullNetworkL1, double fullNetworkL2, boolean training) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels");
        }
        this.fullNetworkL1 = fullNetworkL1;
        this.fullNetworkL2 = fullNetworkL2;
        INDArray preOut = this.preOutput2d(training);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFunction(), this.maskArray, false);
        score += fullNetworkL1 + fullNetworkL2;
        this.score = score /= (double)this.getInputMiniBatchSize();
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetworkL1, double fullNetworkL2) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels");
        }
        INDArray preOut = this.preOutput2d(false);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFunction(), this.maskArray);
        double l1l2 = fullNetworkL1 + fullNetworkL2;
        if (l1l2 != 0.0) {
            scoreArray.addi((Number)l1l2);
        }
        return scoreArray;
    }

    @Override
    public void computeGradientAndScore() {
        if (this.input == null || this.labels == null) {
            return;
        }
        INDArray preOut = this.preOutput2d(true);
        Triple<Gradient, INDArray, INDArray> triple = this.getGradientsAndDelta(preOut);
        this.gradient = triple.getFirst();
        this.score = this.computeScore(this.fullNetworkL1, this.fullNetworkL2, true);
    }

    @Override
    protected void setScoreWithZ(INDArray z) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        Triple<Gradient, INDArray, INDArray> triple = this.getGradientsAndDelta(this.preOutput2d(true));
        INDArray delta = triple.getSecond();
        INDArray epsilonNext = ((INDArray)this.params.get("W")).mmul(delta.transpose()).transpose();
        return new Pair<Gradient, INDArray>(triple.getFirst(), epsilonNext);
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    private Triple<Gradient, INDArray, INDArray> getGradientsAndDelta(INDArray preOut) {
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFn();
        INDArray delta = lossFunction.computeGradient(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getActivationFunction(), this.maskArray);
        INDArray output = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), preOut.dup()));
        DefaultGradient gradient = new DefaultGradient();
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        Nd4j.gemm((INDArray)this.input, (INDArray)delta, (INDArray)weightGradView, (boolean)true, (boolean)false, (double)1.0, (double)0.0);
        biasGradView.assign(delta.sum(new int[]{0}));
        gradient.gradientForVariable().put("W", weightGradView);
        gradient.gradientForVariable().put("b", biasGradView);
        return new Triple<Gradient, INDArray, INDArray>(gradient, delta, output);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.output(training);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.output(true);
    }

    @Override
    public INDArray activate() {
        return this.output(false);
    }

    public INDArray output(INDArray input, boolean training) {
        this.setInput(input);
        return this.output(training);
    }

    public INDArray output(INDArray input) {
        this.setInput(input);
        return this.output(false);
    }

    public INDArray output(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        return super.activate(training);
    }

    @Override
    public double f1Score(DataSet data) {
        return this.f1Score(data.getFeatures(), data.getLabels());
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(examples));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        while (iter.hasNext()) {
            this.fit((DataSet)iter.next());
        }
    }

    @Override
    public int[] predict(INDArray input) {
        INDArray output = this.output(input);
        int[] ret = new int[input.rows()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow(i));
        }
        return ret;
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        int[] intRet = this.predict(dataSet.getFeatures());
        ArrayList<String> ret = new ArrayList<String>();
        for (int i : intRet) {
            ret.add(i, dataSet.getLabelName(i));
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        return this.output(examples);
    }

    @Override
    public void fit(INDArray input, INDArray labels) {
        this.setInput(input);
        this.setLabels(labels);
        this.applyDropOutIfNecessary(true);
        if (this.solver == null) {
            this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
            Updater updater = this.solver.getOptimizer().getUpdater();
            int updaterStateSize = updater.stateSizeForLayer(this);
            if (updaterStateSize > 0) {
                updater.setStateViewArray(this, Nd4j.createUninitialized((int[])new int[]{1, updaterStateSize}, (char)Nd4j.order().charValue()), true);
            }
        }
        this.solver.optimize();
    }

    @Override
    public void fit(DataSet data) {
        this.fit(data.getFeatures(), data.getLabels());
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        INDArray outcomeMatrix = FeatureUtil.toOutcomeMatrix((int[])labels, (int)this.numLabels());
        this.fit(examples, outcomeMatrix);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labels != null) {
            this.labels.data().destroy();
            this.labels = null;
        }
        this.solver = null;
    }

    @Override
    public void fit(INDArray data) {
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    protected INDArray preOutput2d(boolean training) {
        return this.preOutput(training);
    }

    protected INDArray getLabels2d() {
        if (this.labels.rank() > 2) {
            return this.labels.reshape(this.labels.size(2), this.labels.size(1));
        }
        return this.labels;
    }
}

