/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.listeners;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Semaphore;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.SequenceVectors;
import org.deeplearning4j.models.sequencevectors.enums.ListenerEvent;
import org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.nd4j.linalg.util.SerializationUtils;

public class SerializingListener<T extends SequenceElement>
implements VectorsListener<T> {
    private File targetFolder = new File("./");
    private String modelPrefix = "Model_";
    private boolean useBinarySerialization = true;
    private ListenerEvent targetEvent = ListenerEvent.EPOCH;
    private int targetFrequency = 100000;
    private Semaphore locker = new Semaphore(1);

    protected SerializingListener() {
    }

    @Override
    public boolean validateEvent(ListenerEvent event, long argument) {
        try {
            this.locker.acquire();
            if (event == this.targetEvent && argument % (long)this.targetFrequency == 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.locker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(ListenerEvent event, SequenceVectors<T> sequenceVectors, long argument) {
        block6: {
            try {
                this.locker.acquire();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                StringBuilder builder = new StringBuilder(this.targetFolder.getAbsolutePath());
                builder.append("/").append(this.modelPrefix).append("_").append(sdf.format(new Date())).append(".seqvec");
                File targetFile = new File(builder.toString());
                if (this.useBinarySerialization) {
                    SerializationUtils.saveObject(sequenceVectors, (File)targetFile);
                    break block6;
                }
                throw new UnsupportedOperationException("Not implemented yet");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.locker.release();
            }
        }
    }

    public static class Builder<T extends SequenceElement> {
        private File targetFolder = new File("./");
        private String modelPrefix = "Model_";
        private boolean useBinarySerialization = true;
        private ListenerEvent targetEvent = ListenerEvent.EPOCH;
        private int targetFrequency = 100000;

        public Builder(ListenerEvent targetEvent, int frequency) {
            this.targetEvent = targetEvent;
            this.targetFrequency = frequency;
        }

        public Builder<T> setFilenamePrefix(boolean reallyUse) {
            this.useBinarySerialization = reallyUse;
            return this;
        }

        public Builder<T> setTargetFolder(@NonNull String folder) {
            if (folder == null) {
                throw new NullPointerException("folder");
            }
            this.setTargetFolder(new File(folder));
            return this;
        }

        public Builder<T> setTargetFolder(@NonNull File folder) {
            if (folder == null) {
                throw new NullPointerException("folder");
            }
            if (!folder.exists() || !folder.isDirectory()) {
                throw new IllegalStateException("Target folder must exist!");
            }
            this.targetFolder = folder;
            return this;
        }

        public SerializingListener<T> build() {
            SerializingListener listener = new SerializingListener();
            listener.modelPrefix = this.modelPrefix;
            listener.targetFolder = this.targetFolder;
            listener.useBinarySerialization = this.useBinarySerialization;
            listener.targetEvent = this.targetEvent;
            listener.targetFrequency = this.targetFrequency;
            return listener;
        }
    }
}

