/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.glove.Glove;
import org.deeplearning4j.models.paragraphvectors.ParagraphVectors;
import org.deeplearning4j.models.sequencevectors.SequenceVectors;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceElementFactory;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.sequencevectors.serialization.VocabWordFactory;
import org.deeplearning4j.models.word2vec.StaticWord2Vec;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyHolder;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyWord;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.sentenceiterator.BasicLineIterator;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.compression.impl.NoOp;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.AbstractStorage;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.storage.CompressedRamStorage;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordVectorSerializer {
    private static final Logger log = LoggerFactory.getLogger(WordVectorSerializer.class);
    private static final int MAX_SIZE = 50;
    private static final String WHITESPACE_REPLACEMENT = "_Az92_";

    private WordVectorSerializer() {
    }

    private static Word2Vec readTextModel(File modelFile) throws IOException, NumberFormatException {
        Word2Vec ret = new Word2Vec();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(GzipUtils.isCompressedFilename((String)modelFile.getName()) ? new GZIPInputStream(new FileInputStream(modelFile)) : new FileInputStream(modelFile), "UTF-8"));){
            String line = reader.readLine();
            String[] initial = line.split(" ");
            int words = Integer.parseInt(initial[0]);
            int layerSize = Integer.parseInt(initial[1]);
            INDArray syn0 = Nd4j.create((int)words, (int)layerSize);
            InMemoryLookupCache cache = new InMemoryLookupCache(false);
            int currLine = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                assert (split.length == layerSize + 1);
                String word = split[0].replaceAll(WHITESPACE_REPLACEMENT, " ");
                float[] vector = new float[split.length - 1];
                for (int i = 1; i < split.length; ++i) {
                    vector[i - 1] = Float.parseFloat(split[i]);
                }
                syn0.putRow(currLine, Nd4j.create((float[])vector));
                cache.addWordToIndex(cache.numWords(), word);
                cache.addToken(new VocabWord(1.0, word));
                cache.putVocabWord(word);
                ++currLine;
            }
            InMemoryLookupTable<VocabWord> lookupTable = new InMemoryLookupTable.Builder<VocabWord>().cache(cache).vectorLength(layerSize).build();
            lookupTable.setSyn0(syn0);
            ret.setVocab(cache);
            ret.setLookupTable(lookupTable);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Word2Vec readBinaryModel(File modelFile, boolean linebreaks, boolean normalize) throws NumberFormatException, IOException {
        InMemoryLookupTable lookupTable;
        AbstractCache<VocabWord> cache;
        INDArray syn0;
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        try (BufferedInputStream bis = new BufferedInputStream(GzipUtils.isCompressedFilename((String)modelFile.getName()) ? new GZIPInputStream(new FileInputStream(modelFile)) : new FileInputStream(modelFile));
             DataInputStream dis = new DataInputStream(bis);){
            int words = Integer.parseInt(WordVectorSerializer.readString(dis));
            int size = Integer.parseInt(WordVectorSerializer.readString(dis));
            syn0 = Nd4j.create((int)words, (int)size);
            cache = new AbstractCache<VocabWord>();
            WordVectorSerializer.printOutProjectedMemoryUse(words, size, 1);
            lookupTable = new InMemoryLookupTable.Builder<VocabWord>().cache(cache).useHierarchicSoftmax(false).vectorLength(size).build();
            float[] vector = new float[size];
            for (int i = 0; i < words; ++i) {
                String word = WordVectorSerializer.readString(dis);
                log.trace("Loading " + word + " with word " + i);
                for (int j = 0; j < size; ++j) {
                    vector[j] = WordVectorSerializer.readFloat(dis);
                }
                syn0.putRow(i, normalize ? Transforms.unitVec((INDArray)Nd4j.create((float[])vector)) : Nd4j.create((float[])vector));
                VocabWord vw = new VocabWord(1.0, word);
                vw.setIndex(cache.numWords());
                cache.addToken(vw);
                cache.addWordToIndex(vw.getIndex(), vw.getLabel());
                cache.putVocabWord(word);
                if (linebreaks) {
                    dis.readByte();
                }
                Nd4j.getMemoryManager().invokeGcOccasionally();
            }
        }
        finally {
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
        }
        lookupTable.setSyn0(syn0);
        Word2Vec ret = ((Word2Vec.Builder)new Word2Vec.Builder().useHierarchicSoftmax(false).resetModel(false).layerSize(syn0.columns()).allowParallelTokenization(true).elementsLearningAlgorithm((ElementsLearningAlgorithm)new SkipGram())).learningRate(0.025).windowSize(5).workers(1).build();
        ret.setVocab(cache);
        ret.setLookupTable(lookupTable);
        return ret;
    }

    public static float readFloat(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        is.read(bytes);
        return WordVectorSerializer.getFloat(bytes);
    }

    public static float getFloat(byte[] b) {
        int accum = 0;
        accum |= (b[0] & 0xFF) << 0;
        accum |= (b[1] & 0xFF) << 8;
        accum |= (b[2] & 0xFF) << 16;
        return Float.intBitsToFloat(accum |= (b[3] & 0xFF) << 24);
    }

    public static String readString(DataInputStream dis) throws IOException {
        byte[] bytes = new byte[50];
        byte b = dis.readByte();
        int i = -1;
        StringBuilder sb = new StringBuilder();
        while (b != 32 && b != 10) {
            bytes[++i] = b;
            b = dis.readByte();
            if (i != 49) continue;
            sb.append(new String(bytes, "UTF-8"));
            i = -1;
            bytes = new byte[50];
        }
        sb.append(new String(bytes, 0, i + 1, "UTF-8"));
        return sb.toString();
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, String path) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));){
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)bos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, File file) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)bos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, OutputStream stream) throws IOException {
        VocabCache<T> vocabCache = lookupTable.getVocabCache();
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            String str = vocabCache.numWords() + " " + lookupTable.layerSize() + " " + vocabCache.totalNumberOfDocs();
            log.debug("Saving header: {}", (Object)str);
            writer.println(str);
            for (int x = 0; x < vocabCache.numWords(); ++x) {
                T element = vocabCache.elementAtIndex(x);
                StringBuilder builder = new StringBuilder();
                builder.append(WordVectorSerializer.encodeB64(((SequenceElement)element).getLabel())).append(" ");
                INDArray vec = lookupTable.vector(((SequenceElement)element).getLabel());
                for (int i = 0; i < vec.length(); ++i) {
                    builder.append(vec.getDouble(i));
                    if (i >= vec.length() - 1) continue;
                    builder.append(" ");
                }
                writer.println(builder.toString());
            }
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull File path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull String path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream stream = new BufferedOutputStream(fos);){
            WordVectorSerializer.writeParagraphVectors(vectors, stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, String path) {
        WordVectorSerializer.writeParagraphVectors(vectors, new File(path));
    }

    public static void writeWord2VecModel(Word2Vec vectors, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream stream = new BufferedOutputStream(fos);){
            WordVectorSerializer.writeWord2VecModel(vectors, stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWord2VecModel(Word2Vec vectors, String path) {
        WordVectorSerializer.writeWord2VecModel(vectors, new File(path));
    }

    public static void writeWord2VecModel(Word2Vec vectors, OutputStream stream) throws IOException {
        Serializable word;
        Serializable word2;
        int i;
        Serializable builder;
        Serializable builder2;
        ZipOutputStream zipfile = new ZipOutputStream(new BufferedOutputStream((OutputStream)new CloseShieldOutputStream(stream)));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = File.createTempFile("word2vec", "0");
        tempFileSyn0.deleteOnExit();
        WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
        FileUtils.copyFile((File)tempFileSyn0, (OutputStream)zipfile);
        File tempFileSyn1 = File.createTempFile("word2vec", "1");
        tempFileSyn1.deleteOnExit();
        INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
        if (syn1 != null) {
            try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
                for (int x = 0; x < syn1.rows(); ++x) {
                    INDArray row = syn1.getRow(x);
                    builder2 = new StringBuilder();
                    for (int i2 = 0; i2 < row.length(); ++i2) {
                        ((StringBuilder)builder2).append(row.getDouble(i2)).append(" ");
                    }
                    writer.println(((StringBuilder)builder2).toString().trim());
                }
            }
        }
        ZipEntry zSyn1 = new ZipEntry("syn1.txt");
        zipfile.putNextEntry(zSyn1);
        FileUtils.copyFile((File)tempFileSyn1, (OutputStream)zipfile);
        File tempFileSyn1Neg = File.createTempFile("word2vec", "n");
        tempFileSyn1Neg.deleteOnExit();
        INDArray syn1Neg = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1Neg();
        if (syn1Neg != null) {
            PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1Neg));
            builder2 = null;
            try {
                for (int x = 0; x < syn1Neg.rows(); ++x) {
                    INDArray row = syn1Neg.getRow(x);
                    builder = new StringBuilder();
                    for (i = 0; i < row.length(); ++i) {
                        ((StringBuilder)builder).append(row.getDouble(i)).append(" ");
                    }
                    writer.println(((StringBuilder)builder).toString().trim());
                }
            }
            catch (Throwable x) {
                builder2 = x;
                throw x;
            }
            finally {
                if (writer != null) {
                    if (builder2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x) {
                            ((Throwable)builder2).addSuppressed(x);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        ZipEntry zSyn1Neg = new ZipEntry("syn1Neg.txt");
        zipfile.putNextEntry(zSyn1Neg);
        FileUtils.copyFile((File)tempFileSyn1Neg, (OutputStream)zipfile);
        File tempFileCodes = File.createTempFile("word2vec", "h");
        tempFileCodes.deleteOnExit();
        ZipEntry hC = new ZipEntry("codes.txt");
        zipfile.putNextEntry(hC);
        PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));
        builder = null;
        try {
            for (i = 0; i < vectors.getVocab().numWords(); ++i) {
                word2 = (VocabWord)vectors.getVocab().elementAtIndex(i);
                StringBuilder builder3 = new StringBuilder(WordVectorSerializer.encodeB64(((VocabWord)word2).getLabel())).append(" ");
                for (byte code : ((SequenceElement)word2).getCodes()) {
                    builder3.append(code).append(" ");
                }
                writer.println(builder3.toString().trim());
            }
        }
        catch (Throwable i3) {
            builder = i3;
            throw i3;
        }
        finally {
            if (writer != null) {
                if (builder != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable i3) {
                        ((Throwable)builder).addSuppressed(i3);
                    }
                } else {
                    writer.close();
                }
            }
        }
        FileUtils.copyFile((File)tempFileCodes, (OutputStream)zipfile);
        File tempFileHuffman = File.createTempFile("word2vec", "h");
        tempFileHuffman.deleteOnExit();
        ZipEntry hP = new ZipEntry("huffman.txt");
        zipfile.putNextEntry(hP);
        PrintWriter writer2 = new PrintWriter(new FileWriter(tempFileHuffman));
        word2 = null;
        try {
            for (int i4 = 0; i4 < vectors.getVocab().numWords(); ++i4) {
                word = (VocabWord)vectors.getVocab().elementAtIndex(i4);
                StringBuilder builder4 = new StringBuilder(WordVectorSerializer.encodeB64(((VocabWord)word).getLabel())).append(" ");
                for (int point : ((SequenceElement)word).getPoints()) {
                    builder4.append(point).append(" ");
                }
                writer2.println(builder4.toString().trim());
            }
        }
        catch (Throwable i4) {
            word2 = i4;
            throw i4;
        }
        finally {
            if (writer2 != null) {
                if (word2 != null) {
                    try {
                        writer2.close();
                    }
                    catch (Throwable i4) {
                        ((Throwable)word2).addSuppressed(i4);
                    }
                } else {
                    writer2.close();
                }
            }
        }
        FileUtils.copyFile((File)tempFileHuffman, (OutputStream)zipfile);
        File tempFileFreqs = File.createTempFile("word2vec", "f");
        tempFileFreqs.deleteOnExit();
        ZipEntry hF = new ZipEntry("frequencies.txt");
        zipfile.putNextEntry(hF);
        PrintWriter writer3 = new PrintWriter(new FileWriter(tempFileFreqs));
        word = null;
        try {
            for (int i5 = 0; i5 < vectors.getVocab().numWords(); ++i5) {
                VocabWord word3 = (VocabWord)vectors.getVocab().elementAtIndex(i5);
                StringBuilder builder5 = new StringBuilder(WordVectorSerializer.encodeB64(word3.getLabel())).append(" ").append(word3.getElementFrequency()).append(" ").append(vectors.getVocab().docAppearedIn(word3.getLabel()));
                writer3.println(builder5.toString().trim());
            }
        }
        catch (Throwable throwable) {
            word = throwable;
            throw throwable;
        }
        finally {
            if (writer3 != null) {
                if (word != null) {
                    try {
                        writer3.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)word).addSuppressed(throwable);
                    }
                } else {
                    writer3.close();
                }
            }
        }
        FileUtils.copyFile((File)tempFileFreqs, (OutputStream)zipfile);
        ZipEntry config = new ZipEntry("config.json");
        zipfile.putNextEntry(config);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(vectors.getConfiguration().toJson().getBytes(StandardCharsets.UTF_8));){
            IOUtils.copy((InputStream)bais, (OutputStream)zipfile);
        }
        zipfile.flush();
        zipfile.close();
        try {
            tempFileCodes.delete();
            tempFileFreqs.delete();
            tempFileHuffman.delete();
            tempFileSyn0.delete();
            tempFileSyn1.delete();
            tempFileSyn1Neg.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, OutputStream stream) throws IOException {
        Serializable word;
        int i;
        Serializable builder;
        ZipOutputStream zipfile = new ZipOutputStream(new BufferedOutputStream((OutputStream)new CloseShieldOutputStream(stream)));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = File.createTempFile("paravec", "0");
        tempFileSyn0.deleteOnExit();
        WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
        FileUtils.copyFile((File)tempFileSyn0, (OutputStream)zipfile);
        File tempFileSyn1 = File.createTempFile("paravec", "1");
        tempFileSyn1.deleteOnExit();
        INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
        if (syn1 != null) {
            try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
                for (int x = 0; x < syn1.rows(); ++x) {
                    INDArray row = syn1.getRow(x);
                    builder = new StringBuilder();
                    for (i = 0; i < row.length(); ++i) {
                        ((StringBuilder)builder).append(row.getDouble(i)).append(" ");
                    }
                    writer.println(((StringBuilder)builder).toString().trim());
                }
            }
        }
        ZipEntry zSyn1 = new ZipEntry("syn1.txt");
        zipfile.putNextEntry(zSyn1);
        FileUtils.copyFile((File)tempFileSyn1, (OutputStream)zipfile);
        File tempFileCodes = File.createTempFile("paravec", "h");
        tempFileCodes.deleteOnExit();
        ZipEntry hC = new ZipEntry("codes.txt");
        zipfile.putNextEntry(hC);
        PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));
        builder = null;
        try {
            for (i = 0; i < vectors.getVocab().numWords(); ++i) {
                word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                StringBuilder builder2 = new StringBuilder(WordVectorSerializer.encodeB64(((VocabWord)word).getLabel())).append(" ");
                for (byte code : ((SequenceElement)word).getCodes()) {
                    builder2.append(code).append(" ");
                }
                writer.println(builder2.toString().trim());
            }
        }
        catch (Throwable i2) {
            builder = i2;
            throw i2;
        }
        finally {
            if (writer != null) {
                if (builder != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable i2) {
                        ((Throwable)builder).addSuppressed(i2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        FileUtils.copyFile((File)tempFileCodes, (OutputStream)zipfile);
        File tempFileHuffman = File.createTempFile("paravec", "h");
        tempFileHuffman.deleteOnExit();
        ZipEntry hP = new ZipEntry("huffman.txt");
        zipfile.putNextEntry(hP);
        PrintWriter writer2 = new PrintWriter(new FileWriter(tempFileHuffman));
        word = null;
        try {
            for (int i3 = 0; i3 < vectors.getVocab().numWords(); ++i3) {
                VocabWord word2 = (VocabWord)vectors.getVocab().elementAtIndex(i3);
                StringBuilder builder3 = new StringBuilder(WordVectorSerializer.encodeB64(word2.getLabel())).append(" ");
                for (int point : word2.getPoints()) {
                    builder3.append(point).append(" ");
                }
                writer2.println(builder3.toString().trim());
            }
        }
        catch (Throwable i3) {
            word = i3;
            throw i3;
        }
        finally {
            if (writer2 != null) {
                if (word != null) {
                    try {
                        writer2.close();
                    }
                    catch (Throwable i3) {
                        ((Throwable)word).addSuppressed(i3);
                    }
                } else {
                    writer2.close();
                }
            }
        }
        FileUtils.copyFile((File)tempFileHuffman, (OutputStream)zipfile);
        ZipEntry config = new ZipEntry("config.json");
        zipfile.putNextEntry(config);
        IOUtils.write((String)vectors.getConfiguration().toJson(), (OutputStream)zipfile, (Charset)StandardCharsets.UTF_8);
        ZipEntry labels = new ZipEntry("labels.txt");
        zipfile.putNextEntry(labels);
        StringBuilder builder4 = new StringBuilder();
        for (VocabWord word3 : vectors.getVocab().tokens()) {
            if (!word3.isLabel()) continue;
            builder4.append(WordVectorSerializer.encodeB64(word3.getLabel())).append("\n");
        }
        IOUtils.write((String)builder4.toString().trim(), (OutputStream)zipfile, (Charset)StandardCharsets.UTF_8);
        ZipEntry hF = new ZipEntry("frequencies.txt");
        zipfile.putNextEntry(hF);
        File tempFileFreqs = File.createTempFile("paravec", "h");
        tempFileFreqs.deleteOnExit();
        try (PrintWriter writer3 = new PrintWriter(new FileWriter(tempFileFreqs));){
            for (int i4 = 0; i4 < vectors.getVocab().numWords(); ++i4) {
                VocabWord word4 = (VocabWord)vectors.getVocab().elementAtIndex(i4);
                builder4 = new StringBuilder(WordVectorSerializer.encodeB64(word4.getLabel())).append(" ").append(word4.getElementFrequency()).append(" ").append(vectors.getVocab().docAppearedIn(word4.getLabel()));
                writer3.println(builder4.toString().trim());
            }
        }
        FileUtils.copyFile((File)tempFileFreqs, (OutputStream)zipfile);
        zipfile.flush();
        zipfile.close();
    }

    public static ParagraphVectors readParagraphVectors(String path) throws IOException {
        return WordVectorSerializer.readParagraphVectors(new File(path));
    }

    public static ParagraphVectors readParagraphVectors(File file) throws IOException {
        ParagraphVectors vectors;
        block25: {
            Word2Vec w2v = WordVectorSerializer.readWord2Vec(file);
            vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder(w2v.getConfiguration()).vocabCache(w2v.getVocab())).lookupTable(w2v.getLookupTable())).resetModel(false).build();
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry labels = zipFile.getEntry("labels.txt");
                if (labels == null) break block25;
                InputStream stream = zipFile.getInputStream(labels);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        VocabWord word = (VocabWord)vectors.getVocab().tokenFor(WordVectorSerializer.decodeB64(line.trim()));
                        if (word == null) continue;
                        word.markAsLabel(true);
                    }
                }
            }
        }
        vectors.extractLabels();
        return vectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Word2Vec readWord2Vec(File file) throws IOException {
        File tmpFileSyn0 = File.createTempFile("word2vec", "0");
        File tmpFileSyn1 = File.createTempFile("word2vec", "1");
        File tmpFileC = File.createTempFile("word2vec", "c");
        File tmpFileH = File.createTempFile("word2vec", "h");
        File tmpFileF = File.createTempFile("word2vec", "f");
        tmpFileSyn0.deleteOnExit();
        tmpFileSyn1.deleteOnExit();
        tmpFileH.deleteOnExit();
        tmpFileC.deleteOnExit();
        tmpFileF.deleteOnExit();
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        try {
            ZipEntry zsyn1Neg;
            Serializable serializable;
            ZipFile zipFile = new ZipFile(file);
            ZipEntry syn0 = zipFile.getEntry("syn0.txt");
            InputStream stream = zipFile.getInputStream(syn0);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
            ZipEntry syn1 = zipFile.getEntry("syn1.txt");
            stream = zipFile.getInputStream(syn1);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn1);
            ZipEntry codes = zipFile.getEntry("codes.txt");
            stream = zipFile.getInputStream(codes);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileC);
            ZipEntry huffman = zipFile.getEntry("huffman.txt");
            stream = zipFile.getInputStream(huffman);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileH);
            ZipEntry config = zipFile.getEntry("config.json");
            stream = zipFile.getInputStream(config);
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
            }
            VectorsConfiguration configuration = VectorsConfiguration.fromJson(builder.toString().trim());
            Word2Vec w2v = WordVectorSerializer.readWord2VecFromText(tmpFileSyn0, tmpFileSyn1, tmpFileC, tmpFileH, configuration);
            ZipEntry frequencies = zipFile.getEntry("frequencies.txt");
            if (frequencies != null) {
                stream = zipFile.getInputStream(frequencies);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                serializable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] split = line.split(" ");
                        VocabWord word = (VocabWord)w2v.getVocab().tokenFor(WordVectorSerializer.decodeB64(split[0]));
                        word.setElementFrequency((long)Double.parseDouble(split[1]));
                        word.setSequencesCount((long)Double.parseDouble(split[2]));
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (serializable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            if ((zsyn1Neg = zipFile.getEntry("syn1Neg.txt")) != null) {
                stream = zipFile.getInputStream(zsyn1Neg);
                try (InputStreamReader isr = new InputStreamReader(stream);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = null;
                    ArrayList<INDArray> rows = new ArrayList<INDArray>();
                    while ((line = reader.readLine()) != null) {
                        String[] split = line.split(" ");
                        double[] array = new double[split.length];
                        for (int i = 0; i < split.length; ++i) {
                            array[i] = Double.parseDouble(split[i]);
                        }
                        rows.add(Nd4j.create((double[])array));
                    }
                    if (!rows.isEmpty()) {
                        INDArray syn1Neg = Nd4j.vstack(rows);
                        ((InMemoryLookupTable)w2v.getLookupTable()).setSyn1Neg(syn1Neg);
                    }
                }
            }
            serializable = w2v;
            return serializable;
        }
        finally {
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
        }
    }

    public static ParagraphVectors readParagraphVectors(InputStream stream) throws IOException {
        File tmpFile = File.createTempFile("restore", "paravec");
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
        return WordVectorSerializer.readParagraphVectors(tmpFile);
    }

    public static Word2Vec readWord2VecFromText(@NonNull File vectors, @NonNull File hs, @NonNull File h_codes, @NonNull File h_points, @NonNull VectorsConfiguration configuration) throws IOException {
        int i;
        VocabWord word;
        String[] split;
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (hs == null) {
            throw new NullPointerException("hs");
        }
        if (h_codes == null) {
            throw new NullPointerException("h_codes");
        }
        if (h_points == null) {
            throw new NullPointerException("h_points");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(vectors);
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)pair.getFirst();
        lookupTable.setNegative(configuration.getNegative());
        if (configuration.getNegative() > 0.0) {
            lookupTable.initNegative();
        }
        VocabCache vocab = (VocabCache)pair.getSecond();
        BufferedReader reader = new BufferedReader(new FileReader(hs));
        String line = null;
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            double[] array = new double[split.length];
            for (int i2 = 0; i2 < split.length; ++i2) {
                array[i2] = Double.parseDouble(split[i2]);
            }
            rows.add(Nd4j.create((double[])array));
        }
        reader.close();
        if (!rows.isEmpty()) {
            INDArray syn1 = Nd4j.vstack(rows);
            lookupTable.setSyn1(syn1);
        }
        reader = new BufferedReader(new FileReader(h_points));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            word = (VocabWord)vocab.wordFor(WordVectorSerializer.decodeB64(split[0]));
            ArrayList<Integer> points = new ArrayList<Integer>();
            for (i = 1; i < split.length; ++i) {
                points.add(Integer.parseInt(split[i]));
            }
            word.setPoints(points);
        }
        reader.close();
        reader = new BufferedReader(new FileReader(h_codes));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            word = (VocabWord)vocab.wordFor(WordVectorSerializer.decodeB64(split[0]));
            ArrayList<Byte> codes = new ArrayList<Byte>();
            for (i = 1; i < split.length; ++i) {
                codes.add(Byte.parseByte(split[i]));
            }
            word.setCodes(codes);
            word.setCodeLength((short)codes.size());
        }
        reader.close();
        Word2Vec.Builder builder = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache(vocab)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false);
        TokenizerFactory factory = WordVectorSerializer.getTokenizerFactory(configuration);
        if (factory != null) {
            builder.tokenizerFactory(factory);
        }
        Word2Vec w2v = builder.build();
        return w2v;
    }

    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return WordVectorSerializer.readParagraphVectorsFromText(new File(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ParagraphVectors paragraphVectors = WordVectorSerializer.readParagraphVectorsFromText(fis);
            return paragraphVectors;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<INDArray> arrays = new ArrayList<INDArray>();
            AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                split[1] = split[1].replaceAll(WHITESPACE_REPLACEMENT, " ");
                VocabWord word = new VocabWord(1.0, split[1]);
                if (split[0].equals("L")) {
                    word.setSpecial(true);
                    word.markAsLabel(true);
                    labels.add(word.getLabel());
                } else if (split[0].equals("E")) {
                    word.setSpecial(false);
                    word.markAsLabel(false);
                } else {
                    throw new IllegalStateException("Source stream doesn't looks like ParagraphVectors serialized model");
                }
                word.setIndex(vocabCache.numWords());
                vocabCache.addToken(word);
                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                vocabCache.putVocabWord(word.getLabel());
                float[] vector = new float[split.length - 2];
                for (int i = 2; i < split.length; ++i) {
                    vector[i - 2] = Float.parseFloat(split[i]);
                }
                INDArray row = Nd4j.create((float[])vector);
                arrays.add(row);
            }
            INDArray syn = Nd4j.vstack(arrays);
            InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).useAdaGrad(false).cache(vocabCache).build();
            Nd4j.clearNans((INDArray)syn);
            lookupTable.setSyn0(syn);
            LabelsSource source = new LabelsSource(labels);
            ParagraphVectors vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder().labelsSource(source).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).modelUtils((ModelUtils)new BasicModelUtils())).build();
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            vectors.extractLabels();
            return vectors;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull File file) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull String path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(path));){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull OutputStream stream) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            WordVectorSerializer.writeWordVectors(vectors.lookupTable(), stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(ParagraphVectors vectors, OutputStream stream) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            VocabCache vocabCache = vectors.getVocab();
            for (VocabWord word : vocabCache.vocabWords()) {
                StringBuilder builder = new StringBuilder();
                builder.append(word.isLabel() ? "L" : "E").append(" ");
                builder.append(word.getLabel().replaceAll(" ", WHITESPACE_REPLACEMENT)).append(" ");
                INDArray vector = vectors.getWordVectorMatrix(word.getLabel());
                for (int j = 0; j < vector.length(); ++j) {
                    builder.append(vector.getDouble(j));
                    if (j >= vector.length() - 1) continue;
                    builder.append(" ");
                }
                writer.write(builder.append("\n").toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(InMemoryLookupTable lookupTable, InMemoryLookupCache cache, String path) throws IOException {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, false), StandardCharsets.UTF_8));){
            for (int i = 0; i < lookupTable.getSyn0().rows(); ++i) {
                String word = cache.wordAtIndex(i);
                if (word == null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
                sb.append(" ");
                INDArray wordVector = lookupTable.vector(word);
                for (int j = 0; j < wordVector.length(); ++j) {
                    sb.append(wordVector.getDouble(j));
                    if (j >= wordVector.length() - 1) continue;
                    sb.append(" ");
                }
                sb.append("\n");
                write.write(sb.toString());
            }
        }
    }

    private static ObjectMapper getModelMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    @Deprecated
    public static void writeFullModel(@NonNull Word2Vec vec, @NonNull String path) {
        int x;
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WeightLookupTable lookupTable = vec.getLookupTable();
        VocabCache vocabCache = vec.getVocab();
        if (!(lookupTable instanceof InMemoryLookupTable)) {
            throw new IllegalStateException("At this moment only InMemoryLookupTable is supported.");
        }
        VectorsConfiguration conf = vec.getConfiguration();
        conf.setVocabSize(vocabCache.numWords());
        printWriter.println(conf.toJson());
        StringBuilder builder = new StringBuilder();
        for (x = 0; x < ((InMemoryLookupTable)lookupTable).getExpTable().length; ++x) {
            builder.append(((InMemoryLookupTable)lookupTable).getExpTable()[x]).append(" ");
        }
        printWriter.println(builder.toString().trim());
        if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getTable() != null) {
            builder = new StringBuilder();
            for (x = 0; x < ((InMemoryLookupTable)lookupTable).getTable().columns(); ++x) {
                builder.append(((InMemoryLookupTable)lookupTable).getTable().getDouble(x)).append(" ");
            }
            printWriter.println(builder.toString().trim());
        } else {
            printWriter.println("");
        }
        ArrayList words = new ArrayList(vocabCache.vocabWords());
        for (SequenceElement word : words) {
            int x2;
            VocabularyWord vw = new VocabularyWord(word.getLabel());
            vw.setCount(vocabCache.wordFrequency(word.getLabel()));
            vw.setHuffmanNode(VocabularyHolder.buildNode(word.getCodes(), word.getPoints(), word.getCodeLength(), word.getIndex()));
            INDArray syn0 = ((InMemoryLookupTable)lookupTable).getSyn0().getRow(vocabCache.indexOf(word.getLabel()));
            double[] dsyn0 = new double[syn0.columns()];
            for (int x3 = 0; x3 < conf.getLayersSize(); ++x3) {
                dsyn0[x3] = syn0.getDouble(x3);
            }
            vw.setSyn0(dsyn0);
            INDArray syn1 = ((InMemoryLookupTable)lookupTable).getSyn1().getRow(vocabCache.indexOf(word.getLabel()));
            double[] dsyn1 = new double[syn1.columns()];
            for (int x4 = 0; x4 < syn1.columns(); ++x4) {
                dsyn1[x4] = syn1.getDouble(x4);
            }
            vw.setSyn1(dsyn1);
            if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() != null) {
                INDArray syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg().getRow(vocabCache.indexOf(word.getLabel()));
                double[] dsyn1Neg = new double[syn1Neg.columns()];
                for (x2 = 0; x2 < syn1Neg.columns(); ++x2) {
                    dsyn1Neg[x2] = syn1Neg.getDouble(x2);
                }
                vw.setSyn1Neg(dsyn1Neg);
            }
            if (conf.isUseAdaGrad() && ((InMemoryLookupTable)lookupTable).isUseAdaGrad()) {
                INDArray gradient = word.getHistoricalGradient();
                if (gradient == null) {
                    gradient = Nd4j.zeros((int)word.getCodes().size());
                }
                double[] ada = new double[gradient.columns()];
                for (x2 = 0; x2 < gradient.columns(); ++x2) {
                    ada[x2] = gradient.getDouble(x2);
                }
                vw.setHistoricalGradient(ada);
            }
            printWriter.println(vw.toJson());
        }
        printWriter.flush();
        printWriter.close();
    }

    @Deprecated
    public static Word2Vec loadFullModel(@NonNull String path) throws FileNotFoundException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        BasicLineIterator iterator = new BasicLineIterator(new File(path));
        String confJson = iterator.nextSentence();
        log.info("Word2Vec conf. JSON: " + confJson);
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(confJson);
        String eTable = iterator.nextSentence();
        String nTable = iterator.nextSentence();
        if (configuration.getNegative() > 0.0) {
            // empty if block
        }
        VocabularyHolder holder = new VocabularyHolder.Builder().minWordFrequency(configuration.getMinWordFrequency()).hugeModelExpected(configuration.isHugeModelExpected()).scavengerActivationThreshold(configuration.getScavengerActivationThreshold()).scavengerRetentionDelay(configuration.getScavengerRetentionDelay()).build();
        AtomicInteger counter = new AtomicInteger(0);
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            word.setSpecial(true);
            VocabWord vw = new VocabWord(word.getCount(), word.getWord());
            vw.setIndex(counter.getAndIncrement());
            vw.setIndex(word.getHuffmanNode().getIdx());
            vw.setCodeLength(word.getHuffmanNode().getLength());
            vw.setPoints(WordVectorSerializer.arrayToList(word.getHuffmanNode().getPoint(), (int)word.getHuffmanNode().getLength()));
            vw.setCodes(WordVectorSerializer.arrayToList(word.getHuffmanNode().getCode(), (int)word.getHuffmanNode().getLength()));
            vocabCache.addToken(vw);
            vocabCache.addWordToIndex(vw.getIndex(), vw.getLabel());
            vocabCache.putVocabWord(vw.getWord());
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().negative(configuration.getNegative()).useAdaGrad(configuration.isUseAdaGrad()).lr(configuration.getLearningRate()).cache(vocabCache).vectorLength(configuration.getLayersSize()).build();
        lookupTable.resetWeights(true);
        iterator.reset();
        iterator.nextSentence();
        iterator.nextSentence();
        iterator.nextSentence();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            INDArray syn0 = lookupTable.getSyn0().getRow(vocabCache.indexOf(word.getWord()));
            syn0.assign(Nd4j.create((double[])word.getSyn0()));
            INDArray syn1 = lookupTable.getSyn1().getRow(vocabCache.indexOf(word.getWord()));
            syn1.assign(Nd4j.create((double[])word.getSyn1()));
            if (!(configuration.getNegative() > 0.0)) continue;
            INDArray syn1Neg = lookupTable.getSyn1Neg().getRow(vocabCache.indexOf(word.getWord()));
            syn1Neg.assign(Nd4j.create((double[])word.getSyn1Neg()));
        }
        Word2Vec vec = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false).build();
        vec.setModelUtils(new BasicModelUtils());
        return vec;
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull String path) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path), false), "UTF-8"));
        WordVectorSerializer.writeWordVectors(vec, write);
        write.flush();
        write.close();
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull File file) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            WordVectorSerializer.writeWordVectors(vec, write);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull OutputStream outputStream) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            WordVectorSerializer.writeWordVectors(vec, writer);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull BufferedWriter writer) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        int words = 0;
        String str = vec.getVocab().numWords() + " " + vec.getLayerSize() + " " + vec.getVocab().totalNumberOfDocs();
        log.debug("Saving header: {}", (Object)str);
        writer.write(str + "\n");
        for (String word : vec.vocab().words()) {
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
            sb.append(" ");
            INDArray wordVector = vec.getWordVectorMatrix(word);
            for (int j = 0; j < wordVector.length(); ++j) {
                sb.append(wordVector.getDouble(j));
                if (j >= wordVector.length() - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
            writer.write(sb.toString());
            ++words;
        }
        try {
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
    }

    public static WordVectors fromTableAndVocab(WeightLookupTable table, VocabCache vocab) {
        WordVectorsImpl vectors = new WordVectorsImpl();
        vectors.setLookupTable(table);
        vectors.setVocab(vocab);
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    public static Word2Vec fromPair(Pair<InMemoryLookupTable, VocabCache> pair) {
        Word2Vec vectors = new Word2Vec();
        vectors.setLookupTable((WeightLookupTable)pair.getFirst());
        vectors.setVocab((VocabCache)pair.getSecond());
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    @Deprecated
    public static WordVectors loadTxtVectors(File vectorsFile) throws FileNotFoundException, UnsupportedEncodingException {
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(vectorsFile);
        return WordVectorSerializer.fromPair(pair);
    }

    public static Pair<InMemoryLookupTable, VocabCache> loadTxt(File vectorsFile) throws FileNotFoundException, UnsupportedEncodingException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vectorsFile), "UTF-8"));
        AbstractCache<VocabWord> cache = new AbstractCache<VocabWord>();
        LineIterator iter = IOUtils.lineIterator((java.io.Reader)reader);
        String line = null;
        boolean hasHeader = false;
        if (iter.hasNext()) {
            line = iter.nextLine();
            if (!line.contains(" ")) {
                log.debug("Skipping first line");
                hasHeader = true;
            } else {
                String[] split = line.split(" ");
                try {
                    long[] header = new long[split.length];
                    for (int x = 0; x < split.length; ++x) {
                        header[x] = Long.parseLong(split[x]);
                    }
                    if (split.length < 4) {
                        hasHeader = true;
                    }
                    if (split.length == 3) {
                        cache.incrementTotalDocCount(header[2]);
                    }
                    WordVectorSerializer.printOutProjectedMemoryUse(header[0], (int)header[1], 1);
                    hasHeader = true;
                    try {
                        reader.close();
                    }
                    catch (Exception x) {}
                }
                catch (Exception e) {
                    hasHeader = false;
                }
            }
        }
        if (hasHeader) {
            line = "";
            iter.close();
            reader = new BufferedReader(new FileReader(vectorsFile));
            iter = IOUtils.lineIterator((java.io.Reader)reader);
            iter.nextLine();
        }
        ArrayList<INDArray> arrays = new ArrayList<INDArray>();
        while (iter.hasNext()) {
            if (line.isEmpty()) {
                line = iter.nextLine();
            }
            String[] split = line.split(" ");
            String word = WordVectorSerializer.decodeB64(split[0]);
            VocabWord word1 = new VocabWord(1.0, word);
            word1.setIndex(cache.numWords());
            cache.addToken(word1);
            cache.addWordToIndex(word1.getIndex(), word);
            cache.putVocabWord(word);
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            INDArray row = Nd4j.create((float[])vector);
            arrays.add(row);
            line = "";
        }
        INDArray syn = Nd4j.vstack(arrays);
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).useAdaGrad(false).cache(cache).useHierarchicSoftmax(false).build();
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans((INDArray)syn);
        }
        lookupTable.setSyn0(syn);
        iter.close();
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Pair(lookupTable, cache);
    }

    @Deprecated
    public static WordVectors loadTxtVectors(@NonNull InputStream stream, boolean skipFirstLine) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        AbstractCache<VocabWord> cache = new AbstractCache.Builder().build();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        ArrayList<INDArray> arrays = new ArrayList<INDArray>();
        if (skipFirstLine) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(" ");
            String word = split[0].replaceAll(WHITESPACE_REPLACEMENT, " ");
            VocabWord word1 = new VocabWord(1.0, word);
            word1.setIndex(cache.numWords());
            cache.addToken(word1);
            cache.addWordToIndex(word1.getIndex(), word);
            cache.putVocabWord(word);
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            INDArray row = Nd4j.create((float[])vector);
            arrays.add(row);
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).cache(cache).build();
        INDArray syn = Nd4j.vstack(arrays);
        Nd4j.clearNans((INDArray)syn);
        lookupTable.setSyn0(syn);
        return WordVectorSerializer.fromPair((Pair<InMemoryLookupTable, VocabCache>)Pair.makePair(lookupTable, cache));
    }

    public static void writeTsneFormat(Glove vec, INDArray tsne, File csv) throws Exception {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv), StandardCharsets.UTF_8));){
            int words = 0;
            InMemoryLookupCache l = (InMemoryLookupCache)vec.vocab();
            for (String word : vec.vocab().words()) {
                if (word == null) continue;
                StringBuilder sb = new StringBuilder();
                INDArray wordVector = tsne.getRow(l.wordFor(word).getIndex());
                for (int j = 0; j < wordVector.length(); ++j) {
                    sb.append(wordVector.getDouble(j));
                    if (j >= wordVector.length() - 1) continue;
                    sb.append(",");
                }
                sb.append(",");
                sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
                sb.append(" ");
                sb.append("\n");
                write.write(sb.toString());
            }
            log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
        }
    }

    public static void writeTsneFormat(Word2Vec vec, INDArray tsne, File csv) throws Exception {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv), StandardCharsets.UTF_8));){
            int words = 0;
            InMemoryLookupCache l = (InMemoryLookupCache)vec.vocab();
            for (String word : vec.vocab().words()) {
                if (word == null) continue;
                StringBuilder sb = new StringBuilder();
                INDArray wordVector = tsne.getRow(l.wordFor(word).getIndex());
                for (int j = 0; j < wordVector.length(); ++j) {
                    sb.append(wordVector.getDouble(j));
                    if (j >= wordVector.length() - 1) continue;
                    sb.append(",");
                }
                sb.append(",");
                sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
                sb.append(" ");
                sb.append("\n");
                write.write(sb.toString());
            }
            log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
        }
    }

    private static List<Byte> arrayToList(byte[] array, int codeLen) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(array[x]);
        }
        return result;
    }

    private static byte[] listToArray(List<Byte> code) {
        byte[] array = new byte[40];
        for (int x = 0; x < code.size(); ++x) {
            array[x] = code.get(x);
        }
        return array;
    }

    private static int[] listToArray(List<Integer> points, int codeLen) {
        int[] array = new int[points.size()];
        for (int x = 0; x < points.size(); ++x) {
            array[x] = points.get(x);
        }
        return array;
    }

    private static List<Integer> arrayToList(int[] array, int codeLen) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(array[x]);
        }
        return result;
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull String path) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeSequenceVectors(vectors, factory, fos);
        }
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            WordVectorSerializer.writeSequenceVectors(vectors, factory, fos);
        }
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull OutputStream stream) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        WeightLookupTable lookupTable = vectors.getLookupTable();
        VocabCache vocabCache = vectors.getVocab();
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)));){
            writer.write(vectors.getConfiguration().toEncodedJson());
            for (int x = 0; x < vocabCache.numWords(); ++x) {
                Object element = vocabCache.elementAtIndex(x);
                String json = factory.serialize(element);
                INDArray d = Nd4j.create((int)1);
                double[] vector = lookupTable.vector(((SequenceElement)element).getLabel()).dup().data().asDouble();
                ElementPair pair = new ElementPair(json, vector);
                writer.println(pair.toEncodedJson());
                writer.flush();
            }
        }
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        return WordVectorSerializer.readSequenceVectors(factory, new FileInputStream(file));
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull InputStream stream) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = reader.readLine();
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(new String(Base64.decodeBase64((String)line), "UTF-8"));
        AbstractCache<T> vocabCache = new AbstractCache.Builder().build();
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            ElementPair pair = ElementPair.fromEncodedJson(line);
            T element = factory.deserialize(pair.getObject());
            rows.add(Nd4j.create((double[])pair.getVector()));
            vocabCache.addToken(element);
            vocabCache.addWordToIndex(((SequenceElement)element).getIndex(), ((SequenceElement)element).getLabel());
        }
        reader.close();
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)rows.get(0)).columns()).cache(vocabCache).build();
        INDArray syn0 = Nd4j.vstack(rows);
        lookupTable.setSyn0(syn0);
        SequenceVectors vectors = new SequenceVectors.Builder<T>(configuration).vocabCache(vocabCache).lookupTable(lookupTable).resetModel(false).build();
        return vectors;
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull File file) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            WordVectorSerializer.writeVocabCache(vocabCache, fos);
        }
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull OutputStream stream) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)));){
            for (int x = 0; x < vocabCache.numWords(); ++x) {
                VocabWord word = vocabCache.elementAtIndex(x);
                writer.println(word.toJSON());
            }
        }
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            VocabCache<VocabWord> vocabCache = WordVectorSerializer.readVocabCache(fis);
            return vocabCache;
        }
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        VocabWordFactory factory = new VocabWordFactory();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                VocabWord word = factory.deserialize(line);
                vocabCache.addToken(word);
                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
            }
        }
        return vocabCache;
    }

    public static Word2Vec readWord2VecModel(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return WordVectorSerializer.readWord2VecModel(file, false);
    }

    public static Word2Vec readWord2VecModel(String path) {
        return WordVectorSerializer.readWord2VecModel(new File(path));
    }

    public static Word2Vec readWord2VecModel(String path, boolean extendedModel) {
        return WordVectorSerializer.readWord2VecModel(new File(path), extendedModel);
    }

    public static Word2Vec readWord2VecModel(@NonNull File file, boolean extendedModel) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable();
        AbstractCache vocabCache = new AbstractCache();
        INDArray syn0 = null;
        VectorsConfiguration configuration = new VectorsConfiguration();
        if (!file.exists() || !file.isFile()) {
            throw new ND4JIllegalStateException("File [" + file.getAbsolutePath() + "] doesn't exist");
        }
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        try {
            VocabWord word;
            Throwable throwable;
            AutoCloseable reader;
            ZipEntry ve;
            if (extendedModel) {
                log.debug("Trying full model restoration...");
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                return WordVectorSerializer.readWord2Vec(file);
            }
            log.debug("Trying simplified model restoration...");
            File tmpFileSyn0 = File.createTempFile("word2vec", "syn");
            tmpFileSyn0.deleteOnExit();
            File tmpFileConfig = File.createTempFile("word2vec", "config");
            tmpFileConfig.deleteOnExit();
            ZipFile zipFile = new ZipFile(file);
            ZipEntry syn = zipFile.getEntry("syn0.txt");
            InputStream stream = zipFile.getInputStream(syn);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
            ZipEntry config = zipFile.getEntry("config.json");
            if (config != null) {
                stream = zipFile.getInputStream(config);
                StringBuilder builder = new StringBuilder();
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(stream));){
                    String line;
                    while ((line = reader2.readLine()) != null) {
                        builder.append(line);
                    }
                }
                configuration = VectorsConfiguration.fromJson(builder.toString().trim());
            }
            if ((ve = zipFile.getEntry("frequencies.txt")) != null) {
                stream = zipFile.getInputStream(ve);
                AtomicInteger cnt = new AtomicInteger(0);
                reader = new BufferedReader(new InputStreamReader(stream));
                throwable = null;
                try {
                    String line;
                    while ((line = ((BufferedReader)reader).readLine()) != null) {
                        String[] split = line.split(" ");
                        word = new VocabWord(Double.valueOf(split[1]), WordVectorSerializer.decodeB64(split[0]));
                        word.setIndex(cnt.getAndIncrement());
                        word.incrementSequencesCount(Long.valueOf(split[2]));
                        vocabCache.addToken(word);
                        vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                        Nd4j.getMemoryManager().invokeGcOccasionally();
                    }
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((BufferedReader)reader).close();
                            }
                            catch (Throwable line) {
                                throwable.addSuppressed(line);
                            }
                        } else {
                            ((BufferedReader)reader).close();
                        }
                    }
                }
            }
            ArrayList<INDArray> rows = new ArrayList<INDArray>();
            try {
                reader = new CSVReader(tmpFileSyn0);
                throwable = null;
                try {
                    AtomicInteger cnt = new AtomicInteger(0);
                    while (reader.hasNext()) {
                        Pair<VocabWord, float[]> pair = reader.next();
                        word = (VocabWord)pair.getFirst();
                        INDArray vector = Nd4j.create((float[])((float[])pair.getSecond()));
                        if (ve != null) {
                            if (syn0 == null) {
                                syn0 = Nd4j.create((int)vocabCache.numWords(), (int)vector.length());
                            }
                            syn0.getRow(cnt.getAndIncrement()).assign(vector);
                        } else {
                            rows.add(vector);
                            vocabCache.addToken(word);
                            vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                        }
                        Nd4j.getMemoryManager().invokeGcOccasionally();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            }
            if (syn0 == null && vocabCache.numWords() > 0) {
                syn0 = Nd4j.vstack(rows);
            }
            if (syn0 == null) {
                log.error("Can't build syn0 table");
                throw new DL4JInvalidInputException("Can't build syn0 table");
            }
            lookupTable = new InMemoryLookupTable.Builder().cache(vocabCache).vectorLength(syn0.columns()).useHierarchicSoftmax(false).useAdaGrad(false).build();
            lookupTable.setSyn0(syn0);
            try {
                tmpFileSyn0.delete();
                tmpFileConfig.delete();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            try {
                log.debug("Trying CSV model restoration...");
                Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(file);
                lookupTable = (InMemoryLookupTable)pair.getFirst();
                vocabCache = (AbstractCache)pair.getSecond();
            }
            catch (Exception ex) {
                try {
                    log.debug("Trying binary model restoration...");
                    if (originalPeriodic) {
                        Nd4j.getMemoryManager().togglePeriodicGc(true);
                    }
                    Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                    Word2Vec vec = WordVectorSerializer.readBinaryModel(file, true, true);
                    return vec;
                }
                catch (Exception ey) {
                    try {
                        if (originalPeriodic) {
                            Nd4j.getMemoryManager().togglePeriodicGc(true);
                        }
                        Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                        Word2Vec vec = WordVectorSerializer.readBinaryModel(file, false, true);
                        return vec;
                    }
                    catch (Exception ez) {
                        throw new RuntimeException("Unable to guess input file format. Please use corresponding loader directly");
                    }
                }
            }
        }
        Word2Vec.Builder builder = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).lookupTable((WeightLookupTable)lookupTable)).useAdaGrad(false).vocabCache((VocabCache)vocabCache)).layerSize(lookupTable.layerSize()).useHierarchicSoftmax(false).resetModel(false);
        TokenizerFactory factory = WordVectorSerializer.getTokenizerFactory(configuration);
        if (factory != null) {
            builder.tokenizerFactory(factory);
        }
        Word2Vec vec = builder.build();
        return vec;
    }

    protected static TokenizerFactory getTokenizerFactory(VectorsConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        if (configuration.getTokenizerFactory() != null && !configuration.getTokenizerFactory().isEmpty()) {
            try {
                TokenizerFactory factory = (TokenizerFactory)Class.forName(configuration.getTokenizerFactory()).newInstance();
                if (configuration.getTokenPreProcessor() != null && !configuration.getTokenPreProcessor().isEmpty()) {
                    TokenPreProcess preProcessor = (TokenPreProcess)Class.forName(configuration.getTokenPreProcessor()).newInstance();
                    factory.setTokenPreProcessor(preProcessor);
                }
                return factory;
            }
            catch (Exception e) {
                log.error("Can't instantiate saved TokenizerFactory: {}", (Object)configuration.getTokenizerFactory());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WordVectors loadStaticModel(File file) {
        if (!file.exists() || file.isDirectory()) {
            throw new RuntimeException(new FileNotFoundException("File [" + file.getAbsolutePath() + "] was not found"));
        }
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        CompressedRamStorage storage = new CompressedRamStorage.Builder().useInplaceCompression(false).setCompressor((NDArrayCompressor)new NoOp()).emulateIsAbsent(false).build();
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        try {
            log.debug("Trying DL4j format...");
            File tmpFileSyn0 = File.createTempFile("word2vec", "syn");
            tmpFileSyn0.deleteOnExit();
            ZipFile zipFile = new ZipFile(file);
            ZipEntry syn0 = zipFile.getEntry("syn0.txt");
            InputStream stream = zipFile.getInputStream(syn0);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
            storage.clear();
            try (CSVReader reader = new CSVReader(tmpFileSyn0);){
                while (reader.hasNext()) {
                    Pair<VocabWord, float[]> pair = reader.next();
                    VocabWord word = (VocabWord)pair.getFirst();
                    storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                    vocabCache.addToken(word);
                    vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                    Nd4j.getMemoryManager().invokeGcOccasionally();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                try {
                    tmpFileSyn0.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            try {
                vocabCache = new AbstractCache.Builder().build();
                storage.clear();
                log.debug("Trying CSVReader...");
                try (CSVReader reader = new CSVReader(file);){
                    while (reader.hasNext()) {
                        Pair<VocabWord, float[]> pair = reader.next();
                        VocabWord word = (VocabWord)pair.getFirst();
                        storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                        vocabCache.addToken(word);
                        vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                        Nd4j.getMemoryManager().invokeGcOccasionally();
                    }
                }
                catch (Exception ef) {
                    throw new RuntimeException(ef);
                }
                finally {
                    if (originalPeriodic) {
                        Nd4j.getMemoryManager().togglePeriodicGc(true);
                    }
                    Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                }
            }
            catch (Exception ex) {
                block71: {
                    log.debug("Trying BinaryReader...");
                    vocabCache = new AbstractCache.Builder().build();
                    storage.clear();
                    try {
                        try (BinaryReader reader = new BinaryReader(file);){
                            while (reader.hasNext()) {
                                Pair<VocabWord, float[]> pair = reader.next();
                                VocabWord word = (VocabWord)pair.getFirst();
                                storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                                vocabCache.addToken(word);
                                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                                Nd4j.getMemoryManager().invokeGcOccasionally();
                            }
                        }
                        if (!originalPeriodic) break block71;
                    }
                    catch (Exception ez) {
                        throw new RuntimeException("Unable to guess input file format");
                    }
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            }
            finally {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            }
        }
        StaticWord2Vec word2Vec = new StaticWord2Vec.Builder((AbstractStorage<Integer>)storage, vocabCache).build();
        return word2Vec;
    }

    public static String encodeB64(String word) {
        try {
            return "B64:" + Base64.encodeBase64String((byte[])word.getBytes("UTF-8")).replaceAll("(\r|\n)", "");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeB64(String word) {
        if (word.startsWith("B64:")) {
            String arp = word.replaceFirst("B64:", "");
            try {
                return new String(Base64.decodeBase64((String)arp), "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return word;
    }

    public static void printOutProjectedMemoryUse(long numWords, int vectorLength, int numTables) {
        double value;
        String sfx;
        double memSize = numWords * (long)vectorLength * (long)Nd4j.sizeOfDataType() * (long)numTables;
        if (memSize < 1048576.0) {
            sfx = "KB";
            double d = memSize / 1024.0;
        }
        if (memSize < 1.073741824E9) {
            sfx = "MB";
            value = memSize / 1024.0 / 1024.0;
        } else {
            sfx = "GB";
            value = memSize / 1024.0 / 1024.0 / 1024.0;
        }
        OneTimeLogger.info((Logger)log, (String)"Projected memory use for model: [{} {}]", (Object[])new Object[]{String.format("%.2f", value), sfx});
    }

    protected static class CSVReader
    implements Reader {
        private BufferedReader reader;
        private AtomicInteger idxCounter = new AtomicInteger(0);
        private String nextLine;

        protected CSVReader(@NonNull File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            try {
                this.reader = new BufferedReader(new FileReader(file));
                this.nextLine = this.reader.readLine();
                String[] split = this.nextLine.split(" ");
                try {
                    if (Integer.parseInt(split[0]) > 0 && split.length <= 5) {
                        this.nextLine = this.reader.readLine();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public Pair<VocabWord, float[]> next() {
            String[] split = this.nextLine.split(" ");
            VocabWord word = new VocabWord(1.0, WordVectorSerializer.decodeB64(split[0]));
            word.setIndex(this.idxCounter.getAndIncrement());
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (Exception e) {
                this.nextLine = null;
            }
            return Pair.makePair((Object)word, (Object)vector);
        }

        @Override
        public void close() throws Exception {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    protected static class BinaryReader
    implements Reader {
        protected DataInputStream stream;
        protected String nextWord;
        protected int numWords;
        protected int vectorLength;
        protected AtomicInteger idxCounter = new AtomicInteger(0);

        protected BinaryReader(@NonNull File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            try {
                this.stream = new DataInputStream(new BufferedInputStream(GzipUtils.isCompressedFilename((String)file.getName()) ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file)));
                this.numWords = Integer.parseInt(WordVectorSerializer.readString(this.stream));
                this.vectorLength = Integer.parseInt(WordVectorSerializer.readString(this.stream));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.idxCounter.get() < this.numWords;
        }

        @Override
        public Pair<VocabWord, float[]> next() {
            try {
                String word = WordVectorSerializer.readString(this.stream);
                VocabWord element = new VocabWord(1.0, word);
                element.setIndex(this.idxCounter.getAndIncrement());
                float[] vector = new float[this.vectorLength];
                for (int i = 0; i < this.vectorLength; ++i) {
                    vector[i] = WordVectorSerializer.readFloat(this.stream);
                }
                return Pair.makePair((Object)element, (Object)vector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    protected static interface Reader
    extends AutoCloseable {
        public boolean hasNext();

        public Pair<VocabWord, float[]> next();
    }

    private static class ElementPair {
        private String object;
        private double[] vector;

        protected String toEncodedJson() {
            ObjectMapper mapper = SequenceElement.mapper();
            Base64 base64 = new Base64(Integer.MAX_VALUE);
            try {
                String json = mapper.writeValueAsString((Object)this);
                String output = base64.encodeAsString(json.getBytes("UTF-8"));
                return output;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected static ElementPair fromEncodedJson(String encoded) {
            ObjectMapper mapper = SequenceElement.mapper();
            try {
                String decoded = new String(Base64.decodeBase64((String)encoded), "UTF-8");
                return (ElementPair)mapper.readValue(decoded, ElementPair.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getObject() {
            return this.object;
        }

        public double[] getVector() {
            return this.vector;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public void setVector(double[] vector) {
            this.vector = vector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementPair)) {
                return false;
            }
            ElementPair other = (ElementPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            return Arrays.equals(this.getVector(), other.getVector());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElementPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            result = result * 59 + Arrays.hashCode(this.getVector());
            return result;
        }

        public String toString() {
            return "WordVectorSerializer.ElementPair(object=" + this.getObject() + ", vector=" + Arrays.toString(this.getVector()) + ")";
        }

        public ElementPair() {
        }

        public ElementPair(String object, double[] vector) {
            this.object = object;
            this.vector = vector;
        }
    }
}

