/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.nd4j.common.base.Preconditions;

public class CompositePreProcessor
implements TokenPreProcess {
    private List<TokenPreProcess> preProcessors;

    public CompositePreProcessor(TokenPreProcess ... preProcessors) {
        if (preProcessors == null) {
            throw new NullPointerException("preProcessors is marked non-null but is null");
        }
        Preconditions.checkState((preProcessors.length > 0 ? 1 : 0) != 0, (String)"No preprocessors were specified (empty input)");
        this.preProcessors = Arrays.asList(preProcessors);
    }

    public CompositePreProcessor(@NonNull Collection<? extends TokenPreProcess> preProcessors) {
        if (preProcessors == null) {
            throw new NullPointerException("preProcessors is marked non-null but is null");
        }
        Preconditions.checkState((!preProcessors.isEmpty() ? 1 : 0) != 0, (String)"No preprocessors were specified (empty input)");
        this.preProcessors = new ArrayList<TokenPreProcess>(preProcessors);
    }

    @Override
    public String preProcess(String token) {
        String s = token;
        for (TokenPreProcess tpp : this.preProcessors) {
            s = tpp.preProcess(s);
        }
        return s;
    }
}

