/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.serialization;

import java.io.IOException;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceElementFactory;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractElementFactory<T extends SequenceElement>
implements SequenceElementFactory<T> {
    private final Class targetClass;
    protected static final Logger log = LoggerFactory.getLogger(AbstractElementFactory.class);

    public AbstractElementFactory(@NonNull Class<? extends SequenceElement> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        this.targetClass = cls;
    }

    @Override
    public T deserialize(String json) {
        ObjectMapper mapper = SequenceElement.mapper();
        try {
            SequenceElement ret = (SequenceElement)mapper.readValue(json, this.targetClass);
            return (T)ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String serialize(T element) {
        String json = null;
        try {
            json = ((SequenceElement)element).toJSON();
        }
        catch (Exception e) {
            log.error("Direct serialization failed, falling back to jackson");
        }
        if (json == null || json.isEmpty()) {
            ObjectMapper mapper = SequenceElement.mapper();
            try {
                json = mapper.writeValueAsString(element);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }
}

