/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import java.io.Serializable;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.ObjectMapper;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class", defaultImpl=VocabWord.class)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class VocabWord
extends SequenceElement
implements Serializable {
    private static final long serialVersionUID = 2223750736522624256L;
    private String word;
    protected Long vocabId;
    protected Long affinityId;

    public static VocabWord none() {
        return new VocabWord(0.0, "none");
    }

    public VocabWord(double wordFrequency, @NonNull String word) {
        if (word == null) {
            throw new NullPointerException("word is marked non-null but is null");
        }
        if (word.isEmpty()) {
            throw new IllegalArgumentException("Word must not be null or empty");
        }
        this.word = word;
        this.elementFrequency.set(wordFrequency);
        this.storageId = SequenceElement.getLongHash(word);
    }

    public VocabWord(double wordFrequency, @NonNull String word, long storageId) {
        this(wordFrequency, word);
        if (word == null) {
            throw new NullPointerException("word is marked non-null but is null");
        }
        this.storageId = storageId;
    }

    public VocabWord() {
    }

    @Override
    public String getLabel() {
        return this.word;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VocabWord)) {
            return false;
        }
        VocabWord vocabWord = (VocabWord)o;
        if (this.word == null) {
            return vocabWord.word == null;
        }
        return this.word.equals(vocabWord.getWord());
    }

    @Override
    public int hashCode() {
        int result = this.word == null ? 0 : this.word.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "VocabWord{wordFrequency=" + this.elementFrequency + ", index=" + this.index + ", word='" + this.word + '\'' + ", codeLength=" + this.codeLength + '}';
    }

    @Override
    public String toJSON() {
        ObjectMapper mapper = VocabWord.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getVocabId() {
        return this.vocabId;
    }

    public void setVocabId(Long vocabId) {
        this.vocabId = vocabId;
    }

    public Long getAffinityId() {
        return this.affinityId;
    }

    public void setAffinityId(Long affinityId) {
        this.affinityId = affinityId;
    }
}

