/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.sentiwordnet;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.datavec.api.util.ClassPathResource;
import org.deeplearning4j.text.tokenization.tokenizerfactory.UimaTokenizerFactory;

public class SWN3
implements Serializable {
    private static final long serialVersionUID = -2614454572930777658L;
    private HashMap<String, Double> _dict;
    private Set<String> negationWords = Sets.newHashSet((Object[])new String[]{"could", "would", "should", "not", "isn't", "aren't", "wasn't", "weren't", "haven't", "doesn't", "didn't", "don't"});
    private AnalysisEngine analysisEngine;

    public SWN3() throws Exception {
        this(UimaTokenizerFactory.defaultAnalysisEngine());
    }

    public SWN3(AnalysisEngine analysisEngine) {
        this("/sentiment/sentiwordnet.txt");
        this.analysisEngine = analysisEngine;
    }

    public SWN3(String sentiWordNetPath) {
        this._dict = new HashMap();
        HashMap<String, List<Double>> _temp = new HashMap<String, List<Double>>();
        ClassPathResource resource = new ClassPathResource(sentiWordNetPath);
        BufferedReader csv = null;
        try {
            csv = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            String line = "";
            while ((line = csv.readLine()) != null) {
                String[] words;
                String[] data;
                if (line.isEmpty() || (data = line.split("\t"))[2].isEmpty() || data[3].isEmpty()) continue;
                Double score = Double.parseDouble(data[2]) - Double.parseDouble(data[3]);
                for (String w : words = data[4].split(" ")) {
                    int i;
                    List<Double> l;
                    if (w.isEmpty()) continue;
                    String[] w_n = w.split("#");
                    w_n[0] = w_n[0] + "#" + data[0];
                    int index = Integer.parseInt(w_n[1]) - 1;
                    if (_temp.containsKey(w_n[0])) {
                        l = (List)_temp.get(w_n[0]);
                        if (index > l.size()) {
                            for (i = l.size(); i < index; ++i) {
                                l.add(0.0);
                            }
                        }
                        l.add(index, score);
                        _temp.put(w_n[0], l);
                        continue;
                    }
                    l = new ArrayList();
                    for (i = 0; i < index; ++i) {
                        l.add(0.0);
                    }
                    l.add(index, score);
                    _temp.put(w_n[0], l);
                }
            }
            Set temp = _temp.keySet();
            for (String word : temp) {
                int i;
                List l = (List)_temp.get(word);
                double score = 0.0;
                double sum = 0.0;
                for (i = 0; i < l.size(); ++i) {
                    score += 1.0 / (double)(i + 1) * (Double)l.get(i);
                }
                for (i = 1; i <= l.size(); ++i) {
                    sum += 1.0 / (double)i;
                }
                this._dict.put(word, score /= sum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String classify(String text) throws Exception {
        return this.classForScore(this.score(text));
    }

    public double score(String words) throws Exception {
        CAS cas = this.analysisEngine.newCAS();
        cas.setDocumentText(words);
        this.analysisEngine.process(cas);
        return this.score(cas);
    }

    public String classForScore(Double score) {
        String sent = "neutral";
        if (score >= 0.75) {
            sent = "strong_positive";
        } else if (score > 0.25 && score <= 0.5) {
            sent = "positive";
        } else if (score > 0.0 && score >= 0.25) {
            sent = "weak_positive";
        } else if (score < 0.0 && score >= -0.25) {
            sent = "weak_negative";
        } else if (score < -0.25 && score >= -0.5) {
            sent = "negative";
        } else if (score <= -0.75) {
            sent = "strong_negative";
        }
        return sent;
    }

    public String classify(CAS cas) throws CASException {
        return this.classForScore(this.score(cas));
    }

    public double scoreTokens(List<Token> tokens) {
        double totalScore = 0.0;
        HashSet<String> negativeWords = new HashSet<String>();
        double scoreForSentence = 0.0;
        for (Token token : tokens) {
            scoreForSentence += this.extract(token.getCoveredText().toLowerCase()).doubleValue();
            if (!this.negationWords.contains(token.getCoveredText())) continue;
            negativeWords.add(token.getCoveredText());
        }
        if (!negativeWords.isEmpty()) {
            scoreForSentence *= -1.0;
        }
        return totalScore += scoreForSentence;
    }

    public double score(CAS cas) throws CASException {
        double totalScore = 0.0;
        for (Sentence sentence : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
            totalScore += this.scoreTokens(JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence));
        }
        return totalScore;
    }

    public String classify(Sentence sentence) {
        double totalScore = 0.0;
        for (Token token : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
            totalScore += this.extract(token.getCoveredText().toLowerCase()).doubleValue();
        }
        return this.classForScore(totalScore);
    }

    public double score(Sentence sentence) {
        double totalScore = 0.0;
        for (Token token : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
            totalScore += this.extract(token.getCoveredText().toLowerCase()).doubleValue();
        }
        return totalScore;
    }

    public Double extract(String word) {
        double total = 0.0;
        if (this._dict.get(word + "#n") != null) {
            total = this._dict.get(word + "#n") + total;
        }
        if (this._dict.get(word + "#a") != null) {
            total = this._dict.get(word + "#a") + total;
        }
        if (this._dict.get(word + "#r") != null) {
            total = this._dict.get(word + "#r") + total;
        }
        if (this._dict.get(word + "#v") != null) {
            total = this._dict.get(word + "#v") + total;
        }
        return total;
    }

    public static void main(String[] args) {
        SWN3 swn = new SWN3("/sentiment/sentiwordnet.txt");
        System.out.println(swn.classForScore(swn.extract("sad")));
    }
}

