/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.lang.math.RandomUtils;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class SkipGram<T extends SequenceElement>
implements ElementsLearningAlgorithm<T> {
    protected VocabCache<T> vocabCache;
    protected WeightLookupTable<T> lookupTable;
    protected VectorsConfiguration configuration;
    protected static double MAX_EXP = 6.0;
    protected double[] expTable;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected int[] variableWindows;
    protected INDArray syn0;
    protected INDArray syn1;
    protected INDArray syn1Neg;
    protected INDArray table;

    @Override
    public String getCodeName() {
        return "SkipGram";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.expTable = ((InMemoryLookupTable)lookupTable).getExpTable();
        this.syn0 = ((InMemoryLookupTable)lookupTable).getSyn0();
        this.syn1 = ((InMemoryLookupTable)lookupTable).getSyn1();
        this.syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg();
        this.table = ((InMemoryLookupTable)lookupTable).getTable();
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        this.variableWindows = configuration.getVariableWindows();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    public Sequence<T> applySubsampling(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> result = new Sequence<T>();
        if (this.sampling > 0.0) {
            result.setSequenceId(sequence.getSequenceId());
            if (sequence.getSequenceLabels() != null) {
                result.setSequenceLabels(sequence.getSequenceLabels());
            }
            if (sequence.getSequenceLabel() != null) {
                result.setSequenceLabel(sequence.getSequenceLabel());
            }
            for (SequenceElement element : sequence.getElements()) {
                double numWords = this.vocabCache.totalWordOccurrences();
                double ran = (Math.sqrt(element.getElementFrequency() / (this.sampling * numWords)) + 1.0) * (this.sampling * numWords) / element.getElementFrequency();
                nextRandom.set(nextRandom.get() * 25214903917L + 11L);
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                result.addElement(element);
            }
            return result;
        }
        return sequence;
    }

    @Override
    public double learnSequence(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom, @NonNull double learningRate) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        double score = 0.0;
        int currentWindow = this.window;
        if (this.variableWindows != null && this.variableWindows.length != 0) {
            currentWindow = this.variableWindows[RandomUtils.nextInt((int)this.variableWindows.length)];
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            score = this.skipGram(i, tempSequence.getElements(), (int)nextRandom.get() % currentWindow, nextRandom, learningRate, currentWindow);
        }
        return score;
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    private double skipGram(int i, List<T> sentence, int b, AtomicLong nextRandom, double alpha, int currentWindow) {
        SequenceElement word = (SequenceElement)sentence.get(i);
        if (word == null || sentence.isEmpty()) {
            return 0.0;
        }
        double score = 0.0;
        boolean cnt = false;
        int end = currentWindow * 2 + 1 - b;
        for (int a = b; a < end; ++a) {
            int c;
            if (a == currentWindow || (c = i - currentWindow + a) < 0 || c >= sentence.size()) continue;
            SequenceElement lastWord = (SequenceElement)sentence.get(c);
            score = this.iterateSample(word, lastWord, nextRandom, alpha);
        }
        return score;
    }

    public double iterateSample(T w1, T w2, AtomicLong nextRandom, double alpha) {
        INDArray neu1e;
        double score;
        INDArray l1;
        block8: {
            if (w1 == null || w2 == null || ((SequenceElement)w2).getIndex() < 0 || ((SequenceElement)w1).getIndex() == ((SequenceElement)w2).getIndex() || ((SequenceElement)w1).getLabel().equals("STOP") || ((SequenceElement)w2).getLabel().equals("STOP") || ((SequenceElement)w1).getLabel().equals("UNK") || ((SequenceElement)w2).getLabel().equals("UNK")) {
                return 0.0;
            }
            l1 = this.syn0.slice(((SequenceElement)w2).getIndex());
            score = 0.0;
            neu1e = Nd4j.create((int)this.configuration.getLayersSize());
            for (int i = 0; i < ((SequenceElement)w1).getCodeLength(); ++i) {
                int idx;
                int code = ((SequenceElement)w1).getCodes().get(i);
                int point = ((SequenceElement)w1).getPoints().get(i);
                if (point >= this.syn0.rows() || point < 0) {
                    throw new IllegalStateException("Illegal point " + point);
                }
                INDArray syn1 = this.syn1.slice(point);
                double dot = Nd4j.getBlasWrapper().dot(l1, syn1);
                if (dot < -MAX_EXP || dot >= MAX_EXP || (idx = (int)((dot + MAX_EXP) * ((double)this.expTable.length / MAX_EXP / 2.0))) >= this.expTable.length) continue;
                double f = this.expTable[idx];
                double g = this.useAdaGrad ? ((SequenceElement)w1).getGradient(i, (double)(1 - code) - f, alpha) : ((double)(1 - code) - f) * alpha;
                Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, syn1, neu1e);
                Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, l1, syn1);
            }
            int target = ((SequenceElement)w1).getIndex();
            if (!(this.negative > 0.0)) break block8;
            int d = 0;
            while ((double)d < this.negative + 1.0) {
                block11: {
                    double g;
                    block13: {
                        double f;
                        int label;
                        block14: {
                            block12: {
                                block10: {
                                    block9: {
                                        if (d != 0) break block9;
                                        label = 1;
                                        break block10;
                                    }
                                    nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                                    int idx = Math.abs((int)(nextRandom.get() >> 16) % this.table.length());
                                    target = this.table.getInt(new int[]{idx});
                                    if (target <= 0) {
                                        target = (int)nextRandom.get() % (this.vocabCache.numWords() - 1) + 1;
                                    }
                                    if (target == ((SequenceElement)w1).getIndex()) break block11;
                                    label = 0;
                                }
                                if (target >= this.syn1Neg.rows() || target < 0) break block11;
                                f = Nd4j.getBlasWrapper().dot(l1, this.syn1Neg.slice(target));
                                if (!(f > MAX_EXP)) break block12;
                                g = this.useAdaGrad ? this.lookupTable.getGradient(target, label - 1) : (double)(label - 1) * alpha;
                                break block13;
                            }
                            if (!(f < -MAX_EXP)) break block14;
                            g = (double)label * (this.useAdaGrad ? this.lookupTable.getGradient(target, alpha) : alpha);
                            break block13;
                        }
                        int idx = (int)((f + MAX_EXP) * ((double)this.expTable.length / MAX_EXP / 2.0));
                        if (idx >= this.expTable.length) break block11;
                        g = this.useAdaGrad ? this.lookupTable.getGradient(target, (double)label - this.expTable[idx]) : ((double)label - this.expTable[idx]) * alpha;
                    }
                    Nd4j.getBlasWrapper().level1().axpy(this.lookupTable.layerSize(), g, this.syn1Neg.slice(target), neu1e);
                    Nd4j.getBlasWrapper().level1().axpy(this.lookupTable.layerSize(), g, l1, this.syn1Neg.slice(target));
                }
                ++d;
            }
        }
        Nd4j.getBlasWrapper().level1().axpy(this.lookupTable.layerSize(), 1.0, neu1e, l1);
        return score;
    }
}

