/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.perform.text;

import java.io.Serializable;
import java.util.HashSet;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.scaleout.aggregator.JobAggregator;
import org.deeplearning4j.scaleout.job.Job;

public class WordCountJobAggregator
implements JobAggregator {
    private VocabCache<VocabWord> vocabCache;
    public static final String MIN_WORD_FREQUENCY = "org.deeplearning4j.scaleout.perform.text.minwordfrequency";
    private int minWordFrequency = 5;

    public WordCountJobAggregator() {
        this(new InMemoryLookupCache());
    }

    public WordCountJobAggregator(VocabCache vocabCache) {
        this.vocabCache = vocabCache;
    }

    public void accumulate(Job job) {
        Counter wordCounts = (Counter)job.getResult();
        HashSet seen = new HashSet();
        for (String word : wordCounts.keySet()) {
            VocabWord vocabWord;
            VocabWord token;
            this.vocabCache.incrementWordCount(word, (int)wordCounts.getCount((Object)word));
            if (!seen.contains(word)) {
                this.vocabCache.incrementTotalDocCount();
                this.vocabCache.incrementDocCount(word, 1);
            }
            if ((token = this.vocabCache.tokenFor(word)) == null) {
                token = new VocabWord(wordCounts.getCount((Object)word), word);
                this.vocabCache.addToken(token);
                continue;
            }
            if (this.vocabCache.wordFrequency(word) < this.minWordFrequency || (vocabWord = this.vocabCache.wordFor(word)) != null) continue;
            this.vocabCache.putVocabWord(word);
        }
    }

    public Job aggregate() {
        Job ret = new Job((Serializable)((Object)""), "");
        ret.setResult(this.vocabCache);
        return ret;
    }

    public void init(Configuration conf) {
        this.minWordFrequency = conf.getInt(MIN_WORD_FREQUENCY, 5);
    }
}

