/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.sequence;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class SequenceElement
implements Comparable<SequenceElement>,
Serializable {
    private static final long serialVersionUID = 2223750736522624731L;
    protected AtomicDouble elementFrequency = new AtomicDouble(0.0);
    protected int index = -1;
    protected List<Integer> codes = new ArrayList<Integer>();
    protected INDArray historicalGradient;
    protected List<Integer> points = new ArrayList<Integer>();
    protected int codeLength = 0;
    protected boolean special;
    protected Long storageId;

    public abstract String getLabel();

    public double getElementFrequency() {
        return this.elementFrequency.get();
    }

    public void setElementFrequency(long value) {
        this.elementFrequency.set((double)value);
    }

    public void incrementElementFrequency() {
        this.increaseElementFrequency(1);
    }

    public void increaseElementFrequency(int by) {
        this.elementFrequency.getAndAdd((double)by);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SequenceElement)) {
            return false;
        }
        return this.getLabel().equals(((SequenceElement)object).getLabel());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public void setCodes(List<Integer> codes) {
        this.codes = codes;
    }

    public List<Integer> getPoints() {
        return this.points;
    }

    public void setPoints(List<Integer> points) {
        this.points = points;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        int i;
        this.codeLength = codeLength;
        if (this.codes.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.codes.add(0);
            }
        }
        if (this.points.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.points.add(0);
            }
        }
    }

    public double getGradient(int index, double g) {
        if (this.historicalGradient == null) {
            this.historicalGradient = Nd4j.zeros((int)this.getCodes().size());
        }
        double pow = Math.pow(g, 2.0);
        this.historicalGradient.putScalar(index, this.historicalGradient.getDouble(index) + pow);
        double sqrt = FastMath.sqrt((double)this.historicalGradient.getDouble(index));
        double abs = FastMath.abs((double)g) / (sqrt + (double)1.0E-6f);
        double ret = abs * (double)0.1f;
        return ret;
    }

    public int hashCode() {
        if (this.getLabel() == null) {
            throw new IllegalStateException("Label should not be null");
        }
        return this.getLabel().hashCode();
    }

    @Override
    public int compareTo(SequenceElement o) {
        return Double.compare(this.elementFrequency.get(), o.elementFrequency.get());
    }

    public String toString() {
        return "SequenceElement: {label: '" + this.getLabel() + "'," + " freq: '" + this.elementFrequency.get() + "'," + "index: '" + this.index + "'}";
    }

    public abstract String toJSON();

    public INDArray getHistoricalGradient() {
        return this.historicalGradient;
    }

    public void setHistoricalGradient(INDArray historicalGradient) {
        this.historicalGradient = historicalGradient;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public Long getStorageId() {
        return this.storageId;
    }

    public void setStorageId(Long storageId) {
        this.storageId = storageId;
    }
}

