/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import lombok.NonNull;
import org.deeplearning4j.models.glove.count.CoOccurrenceWeight;
import org.deeplearning4j.models.glove.count.CoOccurrenceWriter;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class ASCIICoOccurrenceWriter<T extends SequenceElement>
implements CoOccurrenceWriter<T> {
    private File file;
    private PrintWriter writer;

    public ASCIICoOccurrenceWriter(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        try {
            this.writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 0xA00000));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeObject(CoOccurrenceWeight<T> object) {
        StringBuilder builder = new StringBuilder(String.valueOf(((SequenceElement)object.getElement1()).getIndex())).append(" ").append(String.valueOf(((SequenceElement)object.getElement2()).getIndex())).append(" ").append(String.valueOf(object.getWeight()));
        this.writer.println(builder.toString());
    }

    @Override
    public void queueObject(CoOccurrenceWeight<T> object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

