/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.deeplearning4j.text.annotator.PoStagger;
import org.deeplearning4j.text.annotator.SentenceAnnotator;
import org.deeplearning4j.text.annotator.StemmerAnnotator;
import org.deeplearning4j.text.annotator.TokenizerAnnotator;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;

public class PosUimaTokenizer
implements Tokenizer {
    private static AnalysisEngine engine;
    private List<String> tokens;
    private Collection<String> allowedPosTags;
    private int index;
    private static CAS cas;
    private TokenPreProcess preProcessor;
    private boolean stripNones = false;

    public PosUimaTokenizer(String tokens, AnalysisEngine engine, Collection<String> allowedPosTags) {
        this(tokens, engine, allowedPosTags, false);
    }

    public PosUimaTokenizer(String tokens, AnalysisEngine engine, Collection<String> allowedPosTags, boolean stripNones) {
        if (PosUimaTokenizer.engine == null) {
            PosUimaTokenizer.engine = engine;
        }
        this.allowedPosTags = allowedPosTags;
        this.tokens = new ArrayList<String>();
        this.stripNones = stripNones;
        try {
            if (cas == null) {
                cas = engine.newCAS();
            }
            cas.reset();
            cas.setDocumentText(tokens);
            PosUimaTokenizer.engine.process(cas);
            for (Sentence s : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
                for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)s)) {
                    if (this.valid(t)) {
                        if (t.getLemma() != null) {
                            this.tokens.add(t.getLemma());
                            continue;
                        }
                        if (t.getStem() != null) {
                            this.tokens.add(t.getStem());
                            continue;
                        }
                        this.tokens.add(t.getCoveredText());
                        continue;
                    }
                    this.tokens.add("NONE");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean valid(Token token) {
        String check = token.getCoveredText();
        if (check.matches("<[A-Z]+>") || check.matches("</[A-Z]+>")) {
            return false;
        }
        return token.getPos() == null || this.allowedPosTags.contains(token.getPos());
    }

    @Override
    public boolean hasMoreTokens() {
        return this.index < this.tokens.size();
    }

    @Override
    public int countTokens() {
        return this.tokens.size();
    }

    @Override
    public String nextToken() {
        String ret = this.tokens.get(this.index);
        ++this.index;
        return ret;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            String nextT = this.nextToken();
            if (this.stripNones && nextT.equals("NONE")) continue;
            tokens.add(this.preProcessor != null ? this.preProcessor.preProcess(nextT) : nextT);
        }
        return tokens;
    }

    public static AnalysisEngine defaultAnalysisEngine() {
        try {
            return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenizerAnnotator.getDescription(), PoStagger.getDescription("en"), StemmerAnnotator.getDescription("English")}), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTokenPreProcessor(@NonNull TokenPreProcess tokenPreProcessor) {
        if (tokenPreProcessor == null) {
            throw new NullPointerException("tokenPreProcessor");
        }
        this.preProcessor = tokenPreProcessor;
    }
}

