/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.treeparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.layers.feedforward.autoencoder.recursive.Tree;

public class HeadWordFinder {
    static final String[] head1 = new String[]{"ADJP JJ", "ADJP JJR", "ADJP JJS", "ADVP RB", "ADVP RBB", "LST LS", "NAC NNS", "NAC NN", "NAC PRP", "NAC NNPS", "NAC NNP", "NX NNS", "NX NN", "NX PRP", "NX NNPS", "NX NNP", "NP NNS", "NP NN", "NP PRP", "NP NNPS", "NP NNP", "NP POS", "NP $", "PP IN", "PP TO", "PP RP", "PRT RP", "S VP", "S1 S", "SBAR IN", "SBAR WHNP", "SBARQ SQ", "SBARQ VP", "SINV VP", "SQ MD", "SQ AUX", "VP VB", "VP VBZ", "VP VBP", "VP VBG", "VP VBN", "VP VBD", "VP AUX", "VP AUXG", "VP TO", "VP MD", "WHADJP WRB", "WHADVP WRB", "WHNP WP", "WHNP WDT", "WHNP WP$", "WHPP IN", "WHPP TO"};
    static final String[] head2 = new String[]{"ADJP VBN", "ADJP RB", "NAC NP", "NAC CD", "NAC FW", "NAC ADJP", "NAC JJ", "NX NP", "NX CD", "NX FW", "NX ADJP", "NX JJ", "NP CD", "NP ADJP", "NP JJ", "S SINV", "S SBARQ", "S X", "PRT RB", "PRT IN", "SBAR WHADJP", "SBAR WHADVP", "SBAR WHPP", "SBARQ S", "SBARQ SINV", "SBARQ X", "SINV SBAR", "SQ VP"};
    static final String[] term = new String[]{"AUX", "AUXG", "CC", "CD", "DT", "EX", "FW", "IN", "JJ", "JJR", "JJS", "LS", "MD", "NN", "NNS", "NNP", "NNPS", "PDT", "POS", "PRP", "PRP$", "RB", "RBR", "RBS", "RP", "SYM", "TO", "UH", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ", "WDT", "WP", "WP$", "WRB", "#", "$", ".", ",", ":", "-RRB-", "-LRB-", "``", "''", "EOS"};
    static final String[] punc = new String[]{"#", "$", ".", ",", ":", "-RRB-", "-LRB-", "``", "''"};
    static Set<String> headRules1;
    static Set<String> headRules2;
    static Set<String> terminals;
    static Set<String> punctuations;
    static Map<String, Integer> cache;
    static Boolean setsInitialized;
    boolean includePPHead;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void buildSets() {
        Boolean bl = setsInitialized;
        synchronized (bl) {
            if (setsInitialized.booleanValue()) {
                return;
            }
            headRules1 = new HashSet<String>(Arrays.asList(head1));
            headRules2 = new HashSet<String>(Arrays.asList(head2));
            terminals = new HashSet<String>(Arrays.asList(term));
            punctuations = new HashSet<String>(Arrays.asList(punc));
            cache = new HashMap<String, Integer>();
            setsInitialized = true;
        }
    }

    public HeadWordFinder(boolean includePPHead) {
        this.includePPHead = includePPHead;
        HeadWordFinder.buildSets();
    }

    public HeadWordFinder() {
        this(false);
    }

    public Tree findHead(Tree parentNode) {
        Tree cursor;
        Tree tree = cursor = parentNode.getType().equals("TOP") ? parentNode.firstChild() : parentNode;
        while (cursor.children() != null && !cursor.children().isEmpty()) {
            cursor = this.findHead2(cursor);
        }
        return cursor;
    }

    public Tree findHead2(Tree parentNode) {
        List childNodes = parentNode.children();
        ArrayList<String> childTypes = new ArrayList<String>(childNodes.size());
        String parentType = parentNode.getType();
        for (Tree childNode : childNodes) {
            childTypes.add(childNode.getType());
        }
        int headIndex = this.findHead3(parentType, childTypes);
        return (Tree)childNodes.get(headIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findHead3(String lhs, List<String> rhss) {
        int n;
        StringBuffer keyBuffer = new StringBuffer(lhs + " ->");
        for (String string : rhss) {
            keyBuffer.append(" " + string);
        }
        String key = keyBuffer.toString();
        Map<String, Integer> map = cache;
        synchronized (map) {
            if (cache.containsKey(key)) {
                return cache.get(key);
            }
        }
        int n2 = -1;
        int currentGuessUncertainty = 10;
        for (int current = 0; current < rhss.size(); ++current) {
            String rhs3 = rhss.get(current);
            String rule = lhs + " " + rhs3;
            if (currentGuessUncertainty >= 1 && headRules1.contains(rule)) {
                n = current;
                currentGuessUncertainty = 1;
                continue;
            }
            if (currentGuessUncertainty > 2 && lhs != null && lhs.equals(rhs3)) {
                n = current;
                currentGuessUncertainty = 2;
                continue;
            }
            if (currentGuessUncertainty >= 3 && headRules2.contains(rule)) {
                n = current;
                currentGuessUncertainty = 3;
                continue;
            }
            if (currentGuessUncertainty >= 5 && !terminals.contains(rhs3) && rhs3 != null && !rhs3.equals("PP")) {
                n = current;
                currentGuessUncertainty = 5;
                continue;
            }
            if (currentGuessUncertainty >= 6 && !terminals.contains(rhs3)) {
                n = current;
                currentGuessUncertainty = 6;
                continue;
            }
            if (currentGuessUncertainty < 7) continue;
            n = current;
            currentGuessUncertainty = 7;
        }
        Map<String, Integer> map2 = cache;
        synchronized (map2) {
            cache.put(key, n);
        }
        return n;
    }

    static {
        setsInitialized = false;
    }
}

