/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.token.type.Token;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.uima.UimaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UimaTokenizer
implements Tokenizer {
    private List<String> tokens;
    private int index;
    private static Logger log = LoggerFactory.getLogger(UimaTokenizer.class);
    private boolean checkForLabel;
    private TokenPreProcess preProcess;

    public UimaTokenizer(String tokens, UimaResource resource, boolean checkForLabel) {
        this.checkForLabel = checkForLabel;
        this.tokens = new ArrayList<String>();
        try {
            CAS cas = resource.process(tokens);
            Collection tokenList = JCasUtil.select((JCas)cas.getJCas(), Token.class);
            for (Token t : tokenList) {
                if (checkForLabel && !this.valid(t.getCoveredText())) continue;
                if (t.getLemma() != null) {
                    this.tokens.add(t.getLemma());
                    continue;
                }
                if (t.getStem() != null) {
                    this.tokens.add(t.getStem());
                    continue;
                }
                this.tokens.add(t.getCoveredText());
            }
            resource.release(cas);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private boolean valid(String check) {
        return !check.matches("<[A-Z]+>") && !check.matches("</[A-Z]+>");
    }

    @Override
    public boolean hasMoreTokens() {
        return this.index < this.tokens.size();
    }

    @Override
    public int countTokens() {
        return this.tokens.size();
    }

    @Override
    public String nextToken() {
        String ret = this.tokens.get(this.index);
        ++this.index;
        if (this.preProcess != null) {
            ret = this.preProcess.preProcess(ret);
        }
        return ret;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            tokens.add(this.nextToken());
        }
        return tokens;
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
        this.preProcess = tokenPreProcessor;
    }
}

