/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class VocabWord
implements Comparable<VocabWord>,
Serializable {
    private static final long serialVersionUID = 2223750736522624256L;
    private AtomicDouble wordFrequency = new AtomicDouble(0.0);
    private int index = -1;
    private List<Integer> codes = new ArrayList<Integer>();
    private String word;
    private INDArray historicalGradient;
    private List<Integer> points = new ArrayList<Integer>();
    private int codeLength = 0;

    public static VocabWord none() {
        return new VocabWord(0.0, "none");
    }

    public VocabWord(double wordFrequency, String word) {
        this.wordFrequency.set(wordFrequency);
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word must not be null or empty");
        }
        this.word = word;
    }

    public VocabWord() {
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeDouble(this.wordFrequency.get());
    }

    public VocabWord read(DataInputStream dos) throws IOException {
        this.wordFrequency.set(dos.readDouble());
        return this;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int by) {
        this.wordFrequency.getAndAdd((double)by);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public double getWordFrequency() {
        if (this.wordFrequency == null) {
            return 0.0;
        }
        return this.wordFrequency.get();
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public void setCodes(List<Integer> codes) {
        this.codes = codes;
    }

    @Override
    public int compareTo(VocabWord o) {
        return Double.compare(this.wordFrequency.get(), o.wordFrequency.get());
    }

    public double getGradient(int index, double g) {
        if (this.historicalGradient == null) {
            this.historicalGradient = Nd4j.zeros((int)this.getCodes().size());
        }
        double pow = Math.pow(g, 2.0);
        this.historicalGradient.putScalar(index, this.historicalGradient.getDouble(index) + pow);
        double sqrt = FastMath.sqrt((double)this.historicalGradient.getDouble(index));
        double abs = FastMath.abs((double)g) / (sqrt + (double)1.0E-6f);
        double ret = abs * (double)0.1f;
        return ret;
    }

    public List<Integer> getPoints() {
        return this.points;
    }

    public void setPoints(List<Integer> points) {
        this.points = points;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        int i;
        this.codeLength = codeLength;
        if (this.codes.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.codes.add(0);
            }
        }
        if (this.points.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.points.add(0);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VocabWord)) {
            return false;
        }
        VocabWord vocabWord = (VocabWord)o;
        if (this.codeLength != vocabWord.codeLength) {
            return false;
        }
        if (this.index != vocabWord.index) {
            return false;
        }
        if (!this.codes.equals(vocabWord.codes)) {
            return false;
        }
        if (this.historicalGradient != null ? !this.historicalGradient.equals(vocabWord.historicalGradient) : vocabWord.historicalGradient != null) {
            return false;
        }
        if (!this.points.equals(vocabWord.points)) {
            return false;
        }
        if (!this.word.equals(vocabWord.word)) {
            return false;
        }
        return this.wordFrequency.equals(vocabWord.wordFrequency);
    }

    public int hashCode() {
        int result = this.wordFrequency.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.codes.hashCode();
        result = 31 * result + this.word.hashCode();
        result = 31 * result + (this.historicalGradient != null ? this.historicalGradient.hashCode() : 0);
        result = 31 * result + this.points.hashCode();
        result = 31 * result + this.codeLength;
        return result;
    }

    public String toString() {
        return "VocabWord{wordFrequency=" + this.wordFrequency + ", index=" + this.index + ", codes=" + this.codes + ", word='" + this.word + '\'' + ", historicalGradient=" + this.historicalGradient + ", points=" + this.points + ", codeLength=" + this.codeLength + '}';
    }
}

