/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.invertedindex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.stopwords.StopWords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneInvertedIndex
implements InvertedIndex,
IndexReader.ReaderClosedListener,
Iterator<List<VocabWord>> {
    private transient Directory dir;
    private transient IndexReader reader;
    private transient Analyzer analyzer;
    private transient IndexSearcher searcher;
    private transient IndexWriter writer;
    private VocabCache vocabCache;
    public static final String WORD_FIELD = "word";
    private int numDocs = 0;
    private List<List<VocabWord>> words = Collections.synchronizedList(new ArrayList());
    private boolean cache = true;
    private transient ExecutorService indexManager;
    private AtomicBoolean indexBeingCreated = new AtomicBoolean(false);
    private static Logger log = LoggerFactory.getLogger(LuceneInvertedIndex.class);
    public static final String INDEX_PATH = "word2vec-index";
    private AtomicBoolean readerClosed = new AtomicBoolean(false);
    private AtomicInteger totalWords = new AtomicInteger(0);
    private int batchSize = 1000;
    private List<List<VocabWord>> miniBatches = new CopyOnWriteArrayList<List<VocabWord>>();
    private double sample = 0.0;
    private AtomicLong nextRandom = new AtomicLong(5L);
    private String indexPath = "word2vec-index";
    private transient ScheduledExecutorService miniBatchManager = Executors.newScheduledThreadPool(1);
    private Queue<List<VocabWord>> miniBatchDocs = new ConcurrentLinkedDeque<List<VocabWord>>();
    private AtomicBoolean miniBatchGoing = new AtomicBoolean(true);

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache) {
        this.vocabCache = vocabCache;
        this.cache = cache;
        this.indexManager = Executors.newFixedThreadPool(1);
        this.startMiniBatches();
    }

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache, String indexPath) {
        this.vocabCache = vocabCache;
        this.cache = cache;
        this.indexPath = indexPath;
        this.indexManager = Executors.newFixedThreadPool(1);
        this.startMiniBatches();
    }

    private LuceneInvertedIndex() {
        this.indexManager = Executors.newFixedThreadPool(1);
        this.startMiniBatches();
    }

    @Override
    public double sample() {
        return this.sample;
    }

    @Override
    public Iterator<List<VocabWord>> miniBatches() {
        return this;
    }

    @Override
    public List<VocabWord> document(int index) {
        if (this.cache) {
            List<VocabWord> ret = this.words.get(index);
            ArrayList<VocabWord> ret2 = new ArrayList<VocabWord>();
            for (VocabWord word : ret) {
                if (!this.vocabCache.containsWord(word.getWord())) continue;
                ret2.add(word);
            }
            return ret2;
        }
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        try {
            String[] values;
            this.initReader();
            Document doc = this.reader.document(index);
            for (String s : values = doc.getValues(WORD_FIELD)) {
                ret.add(this.vocabCache.wordFor(s));
            }
        }
        catch (AlreadyClosedException e1) {
            this.reader = null;
            this.readerClosed.set(false);
            return this.document(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public List<Integer> documents(VocabWord vocabWord) {
        try {
            TermQuery query = new TermQuery(new Term(WORD_FIELD, vocabWord.getWord()));
            TopDocs topdocs = this.searcher.search((Query)query, Integer.MAX_VALUE);
            ArrayList<Integer> ret = new ArrayList<Integer>();
            for (int i = 0; i < topdocs.totalHits; ++i) {
                ret.add(topdocs.scoreDocs[i].doc);
            }
            return ret;
        }
        catch (AlreadyClosedException e) {
            this.initReader();
            return this.documents(vocabWord);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numDocuments() {
        int ret;
        if (this.numDocs > 0) {
            return this.numDocs;
        }
        try {
            this.initReader();
            ret = this.reader.numDocs();
        }
        catch (Exception e) {
            return 0;
        }
        return ret;
    }

    @Override
    public Collection<Integer> allDocs() {
        if (this.cache) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            for (int i = 0; i < this.words.size(); ++i) {
                ret.add(i);
            }
            return ret;
        }
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        for (int i = 0; i < this.reader.maxDoc() + 1; ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            docIds.add(i);
        }
        return docIds;
    }

    @Override
    public void addWordToDoc(int doc, VocabWord word) {
        TextField f = new TextField(WORD_FIELD, word.getWord(), Field.Store.YES);
        try {
            this.initReader();
            Document doc2 = this.searcher.doc(doc);
            if (doc2 != null) {
                doc2.add((IndexableField)f);
            } else {
                Document d = new Document();
                d.add((IndexableField)f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initReader();
    }

    private void initReader() {
        if (this.reader == null) {
            try {
                this.writer.commit();
                this.reader = DirectoryReader.open((Directory)this.dir);
                this.searcher = new IndexSearcher(this.reader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.readerClosed.get()) {
            try {
                this.reader = DirectoryReader.open((Directory)this.dir);
                this.searcher = new IndexSearcher(this.reader);
                this.readerClosed.set(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addWordsToDoc(int doc, final List<VocabWord> words) {
        if (this.cache) {
            this.words.add(words);
            this.indexManager.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (LuceneInvertedIndex.this.writer == null) {
                            if (!LuceneInvertedIndex.this.indexBeingCreated.get()) {
                                LuceneInvertedIndex.this.createWriter();
                            } else {
                                LuceneInvertedIndex.this.waitOnWriter();
                            }
                        }
                        Document d = new Document();
                        for (VocabWord word : words) {
                            d.add((IndexableField)new TextField(LuceneInvertedIndex.WORD_FIELD, word.getWord(), Field.Store.YES));
                        }
                        LuceneInvertedIndex.this.writer.addDocument((Iterable)d, LuceneInvertedIndex.this.analyzer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    LuceneInvertedIndex.this.initReader();
                }
            });
        } else {
            Document d = new Document();
            for (VocabWord word : words) {
                d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
            }
            try {
                while (this.writer == null) {
                    if (!this.indexBeingCreated.get() || this.writer == null) {
                        this.createWriter();
                        continue;
                    }
                    this.waitOnWriter();
                }
                this.writer.addDocument((Iterable)d, this.analyzer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.initReader();
        }
        this.totalWords.set(this.totalWords.get() + words.size());
        this.miniBatchDocs.add(words);
    }

    private void startMiniBatches() {
        this.miniBatchManager.schedule(new Runnable(){

            @Override
            public void run() {
                ArrayList<VocabWord> currMiniBatch = new ArrayList<VocabWord>();
                while (LuceneInvertedIndex.this.miniBatchGoing.get()) {
                    List words = (List)LuceneInvertedIndex.this.miniBatchDocs.poll();
                    if (words == null || words.isEmpty()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    for (VocabWord word : words) {
                        if (LuceneInvertedIndex.this.sample > 0.0) {
                            double ran = (Math.sqrt(word.getWordFrequency() / (LuceneInvertedIndex.this.sample * (double)LuceneInvertedIndex.this.numDocuments())) + 1.0) * (LuceneInvertedIndex.this.sample * (double)LuceneInvertedIndex.this.numDocuments()) / word.getWordFrequency();
                            if (ran < (double)(LuceneInvertedIndex.this.nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                            currMiniBatch.add(word);
                            continue;
                        }
                        currMiniBatch.add(word);
                        if (currMiniBatch.size() < LuceneInvertedIndex.this.batchSize) continue;
                        LuceneInvertedIndex.this.miniBatches.add(new ArrayList(currMiniBatch));
                        currMiniBatch.clear();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void ensureDirExists() throws Exception {
        if (this.dir == null) {
            this.dir = FSDirectory.open((File)new File(this.indexPath));
            File dir2 = new File(this.indexPath);
            if (!dir2.exists()) {
                dir2.mkdir();
            }
        }
    }

    private void createWriter() {
        try {
            this.ensureDirExists();
            if (this.analyzer == null) {
                this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream("".getBytes())));
            }
            IndexWriterConfig iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
            if (!this.indexBeingCreated.get() && this.writer == null) {
                this.indexBeingCreated.set(true);
                this.writer = new IndexWriter(this.dir, iwc);
            } else if (!this.indexBeingCreated.get()) {
                this.indexBeingCreated.set(true);
                this.writer = new IndexWriter(this.dir, iwc);
            }
        }
        catch (LockObtainFailedException e) {
            try {
                IndexWriter.unlock((Directory)this.dir);
            }
            catch (IOException e1) {
                throw new RuntimeException("Unable to unlock directory " + this.indexPath);
            }
            try {
                IndexWriterConfig iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                this.writer = new IndexWriter(this.dir, iwc);
            }
            catch (IOException e1) {
                log.warn("Failed to created writer...trying again");
                this.createWriter();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to created writer", e);
        }
    }

    private void waitOnWriter() {
        while (this.writer == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void finish() {
        if (this.cache) {
            this.indexManager.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexWriterConfig iwc = new IndexWriterConfig(Version.LATEST, LuceneInvertedIndex.this.analyzer);
                        if (LuceneInvertedIndex.this.dir == null) {
                            LuceneInvertedIndex.this.dir = (Directory)FSDirectory.open((File)new File(LuceneInvertedIndex.INDEX_PATH));
                        }
                        if (LuceneInvertedIndex.this.writer == null) {
                            if (!LuceneInvertedIndex.this.indexBeingCreated.get()) {
                                LuceneInvertedIndex.this.writer = new IndexWriter(LuceneInvertedIndex.this.dir, iwc);
                            } else {
                                LuceneInvertedIndex.this.waitOnWriter();
                            }
                        }
                        if (IndexWriter.isLocked((Directory)LuceneInvertedIndex.this.dir)) {
                            IndexWriter.unlock((Directory)LuceneInvertedIndex.this.dir);
                        }
                        LuceneInvertedIndex.this.writer.forceMerge(1);
                        LuceneInvertedIndex.this.writer.commit();
                        LuceneInvertedIndex.this.initReader();
                        LuceneInvertedIndex.this.numDocs = LuceneInvertedIndex.this.reader.numDocs();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            try {
                log.info("Committing index...");
                this.writer.forceMerge(1);
                this.writer.commit();
                log.info("Finished committing changes");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.initReader();
            this.numDocs = this.reader.numDocs();
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.indexManager.shutdown();
        this.miniBatchManager.shutdown();
        try {
            this.indexManager.awaitTermination(1L, TimeUnit.DAYS);
            this.miniBatchGoing.set(false);
            this.miniBatchManager.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int totalWords() {
        return this.totalWords.get();
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    public void onClose(IndexReader reader) {
        this.readerClosed.set(true);
    }

    @Override
    public boolean hasNext() {
        return !this.miniBatchDocs.isEmpty() || this.miniBatchGoing.get() || !this.miniBatchManager.isShutdown();
    }

    @Override
    public List<VocabWord> next() {
        if (!this.miniBatchDocs.isEmpty()) {
            return this.miniBatchDocs.poll();
        }
        if (!this.miniBatchManager.isShutdown()) {
            while (this.miniBatchDocs.isEmpty()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.warn("Waiting on more data...");
                if (!this.miniBatchManager.isShutdown()) continue;
                return this.miniBatchDocs.poll();
            }
        }
        return null;
    }

    public static class Builder {
        private File indexDir;
        private Directory dir;
        private IndexReader reader;
        private Analyzer analyzer;
        private IndexSearcher searcher;
        private IndexWriter writer;
        private IndexWriterConfig iwc;
        private VocabCache vocabCache;
        private List<String> stopWords;
        private boolean cache;
        private int batchSize;
        private double sample;

        public Builder() {
            this.iwc = new IndexWriterConfig(Version.LUCENE_4_10_0, this.analyzer);
            this.stopWords = StopWords.getStopWords();
            this.cache = true;
            this.batchSize = 1000;
            this.sample = 0.0;
        }

        public Builder cacheInRam(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder sample(double sample) {
            this.sample = sample;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder indexDir(File indexDir) {
            this.indexDir = indexDir;
            return this;
        }

        public Builder cache(VocabCache cache) {
            this.vocabCache = cache;
            return this;
        }

        public Builder stopWords(List<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder dir(Directory dir) {
            this.dir = dir;
            return this;
        }

        public Builder reader(IndexReader reader) {
            this.reader = reader;
            return this;
        }

        public Builder writer(IndexWriter writer) {
            this.writer = writer;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public InvertedIndex build() {
            LuceneInvertedIndex ret = new LuceneInvertedIndex();
            try {
                if (this.analyzer == null) {
                    this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream(StringUtils.join(this.stopWords, (String)"\n").getBytes())));
                }
                if (this.indexDir != null && this.dir != null) {
                    throw new IllegalStateException("Please define only a directory or a file directory");
                }
                if (this.iwc == null) {
                    this.iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                }
                if (this.indexDir != null && !this.cache) {
                    if (!this.indexDir.exists()) {
                        this.indexDir.mkdirs();
                    }
                    this.dir = FSDirectory.open((File)this.indexDir);
                    if (this.writer == null) {
                        this.writer = new IndexWriter(this.dir, this.iwc);
                    }
                }
                if (this.vocabCache == null) {
                    throw new IllegalStateException("Vocab cache must not be null");
                }
                ret.batchSize = this.batchSize;
                ret.vocabCache = this.vocabCache;
                ret.dir = this.dir;
                ret.writer = this.writer;
                ret.cache = this.cache;
                ret.reader = this.reader;
                ret.searcher = this.searcher;
                ret.analyzer = this.analyzer;
                ret.vocabCache = this.vocabCache;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
    }
}

