/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Huffman {
    private static Logger log = LoggerFactory.getLogger(Huffman.class);
    private List<VocabWord> words;

    public Huffman(Collection<VocabWord> words) {
        this.words = new ArrayList<VocabWord>(words);
    }

    public void build() {
        int a;
        long[] count = new long[this.words.size() * 2 + 1];
        int[] binary = new int[this.words.size() * 2 + 1];
        int[] code = new int[40];
        int[] point = new int[40];
        int[] parentNode = new int[this.words.size() * 2 + 1];
        for (a = 0; a < this.words.size(); ++a) {
            count[a] = (long)this.words.get(a).getWordFrequency();
        }
        for (a = this.words.size(); a < this.words.size() * 2; ++a) {
            count[a] = Integer.MAX_VALUE;
        }
        int pos1 = this.words.size() - 1;
        int pos2 = this.words.size();
        a = 0;
        for (a = 0; a < this.words.size() - 1; ++a) {
            int min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            int min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            count[this.words.size() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.words.size() + a;
            parentNode[min2i] = this.words.size() + a;
            binary[min2i] = 1;
        }
        for (a = 0; a < this.words.size(); ++a) {
            int b = a;
            int i = 0;
            do {
                code[i] = binary[b];
                point[i] = b;
            } while ((b = parentNode[b]) != this.words.size() * 2 - 2 && ++i < 39);
            this.words.get(a).setCodeLength(i);
            this.words.get((int)a).getPoints()[0] = this.words.size() - 2;
            for (b = 0; b < i; ++b) {
                this.words.get((int)a).getCodes()[i - b - 1] = code[b];
                this.words.get((int)a).getPoints()[i - b] = point[b] - this.words.size();
            }
        }
    }
}

