/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.loader;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class Word2VecLoader {
    private static final int MAX_SIZE = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Word2Vec loadGoogleBinary(String path) throws IOException {
        InMemoryLookupCache cache;
        FilterInputStream dis = null;
        BufferedInputStream bis = null;
        double len = 0.0;
        float vector = 0.0f;
        int size = 0;
        try {
            bis = new BufferedInputStream(new FileInputStream(path));
            dis = new DataInputStream(bis);
            int words = Integer.parseInt(Word2VecLoader.readString((DataInputStream)dis));
            size = Integer.parseInt(Word2VecLoader.readString((DataInputStream)dis));
            cache = new InMemoryLookupCache(size, words);
            float[] vectors = null;
            for (int i = 0; i < words; ++i) {
                int j;
                String word = Word2VecLoader.readString((DataInputStream)dis);
                vectors = new float[size];
                len = 0.0;
                for (j = 0; j < size; ++j) {
                    vector = Word2VecLoader.readFloat(dis);
                    len += (double)(vector * vector);
                    vectors[j] = vector;
                }
                len = Math.sqrt(len);
                j = 0;
                while (j < size) {
                    int n = j++;
                    vectors[n] = (float)((double)vectors[n] / len);
                }
                INDArray row = Nd4j.create((float[])vectors);
                if (word == null || word.isEmpty()) continue;
                cache.addWordToIndex(cache.numWords(), word);
                cache.putVector(word, row);
                cache.addToken(new VocabWord(1.0, word));
                cache.putVocabWord(word);
                dis.read();
            }
        }
        finally {
            bis.close();
            dis.close();
        }
        Word2Vec ret = new Word2Vec();
        ret.setCache(cache);
        ret.setLayerSize(size);
        return ret;
    }

    private static String readString(DataInputStream dis) throws IOException {
        byte[] bytes = new byte[50];
        byte b = dis.readByte();
        int i = -1;
        StringBuilder sb = new StringBuilder();
        while (b != 32 && b != 10) {
            bytes[++i] = b;
            b = dis.readByte();
            if (i != 49) continue;
            sb.append(new String(bytes));
            i = -1;
            bytes = new byte[50];
        }
        sb.append(new String(bytes, 0, i + 1));
        return sb.toString();
    }

    public static float readFloat(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        is.read(bytes);
        return Word2VecLoader.getFloat(bytes);
    }

    public static float getFloat(byte[] b) {
        int accum = 0;
        accum |= (b[0] & 0xFF) << 0;
        accum |= (b[1] & 0xFF) << 8;
        accum |= (b[2] & 0xFF) << 16;
        return Float.intBitsToFloat(accum |= (b[3] & 0xFF) << 24);
    }
}

