/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.DataFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.ReshapePreprocessor;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;

public class KerasReshape
extends KerasLayer {
    private long[] targetShape;

    public KerasReshape(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    private long[] listToLongArray(List<Integer> list) {
        long[] retVal = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = list.get(i).intValue();
        }
        return retVal;
    }

    public KerasReshape(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        String targetShape = "target_shape";
        if (innerConfig.containsKey(targetShape)) {
            List targetShapeList = (List)innerConfig.get(targetShape);
            this.targetShape = this.listToLongArray(targetShapeList);
        }
    }

    @Override
    public boolean isInputPreProcessor() {
        return true;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Reshape layer accepts only one input (received " + inputType.length + ")");
        }
        ReshapePreprocessor preprocessor = null;
        if (inputType[0] instanceof InputType.InputTypeConvolutional) {
            InputType.InputTypeConvolutional it = (InputType.InputTypeConvolutional)inputType[0];
            long[] inputShape = new long[]{it.getChannels(), it.getHeight(), it.getWidth()};
            KerasLayer.DimOrder dimOrder = this.getDimOrder();
            if (dimOrder == KerasLayer.DimOrder.THEANO || dimOrder == KerasLayer.DimOrder.NONE && this.kerasMajorVersion == 1) {
                this.targetShape = this.targetShape.length == 2 ? new long[]{this.targetShape[1], this.targetShape[0]} : new long[]{this.targetShape[1], this.targetShape[0], this.targetShape[2]};
                preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, (DataFormat)CNN2DFormat.NCHW);
            } else {
                preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, (DataFormat)CNN2DFormat.NHWC);
            }
        } else if (inputType[0] instanceof InputType.InputTypeConvolutional3D) {
            InputType.InputTypeConvolutional3D it = (InputType.InputTypeConvolutional3D)inputType[0];
            long[] inputShape = new long[]{it.getDepth(), it.getHeight(), it.getWidth(), it.getChannels()};
            KerasLayer.DimOrder dimOrder = this.getDimOrder();
            if (dimOrder == KerasLayer.DimOrder.THEANO || dimOrder == KerasLayer.DimOrder.NONE && this.kerasMajorVersion == 1) {
                this.targetShape = this.targetShape.length == 3 ? new long[]{this.targetShape[1], this.targetShape[0], this.targetShape[2]} : new long[]{this.targetShape[2], this.targetShape[1], this.targetShape[0], this.targetShape[3]};
                preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, null);
            } else {
                if (inputShape[0] != this.targetShape[0]) {
                    this.targetShape = new long[]{this.targetShape[3], this.targetShape[0], this.targetShape[1], this.targetShape[2]};
                }
                preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, null);
            }
        } else if (inputType[0] instanceof InputType.InputTypeRecurrent) {
            InputType.InputTypeRecurrent it = (InputType.InputTypeRecurrent)inputType[0];
            long[] inputShape = new long[]{it.getSize(), it.getTimeSeriesLength()};
            preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, null);
        } else if (inputType[0] instanceof InputType.InputTypeFeedForward) {
            InputType.InputTypeFeedForward it = (InputType.InputTypeFeedForward)inputType[0];
            long[] inputShape = new long[]{it.getSize()};
            if (this.targetShape.length == 3) {
                this.targetShape = this.targetShapeForDimOrder(inputShape, this.targetShape);
            }
            preprocessor = new ReshapePreprocessor(inputShape, this.targetShape, false, null);
        }
        return preprocessor;
    }

    public long[] targetShapeForDimOrder(long[] inputShape, long[] targetShape) {
        if (this.dimOrder == KerasLayer.DimOrder.THEANO || this.dimOrder == KerasLayer.DimOrder.NONE && this.kerasMajorVersion == 1) {
            targetShape = this.dimOrder == KerasLayer.DimOrder.NONE ? new long[]{targetShape[2], targetShape[0], targetShape[1]} : new long[]{targetShape[1], targetShape[2], targetShape[0]};
        } else if (inputShape[0] != targetShape[0]) {
            targetShape = new long[]{targetShape[0], targetShape[1], targetShape[2]};
        }
        return targetShape;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Reshape layer accepts only one input (received " + inputType.length + ")");
        }
        ReshapePreprocessor reshape = (ReshapePreprocessor)this.getInputPreprocessor(inputType);
        return reshape.getOutputType(inputType[0]);
    }
}

