/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DepthwiseConvolution2D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasRegularizerUtils;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasDepthwiseConvolution2D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasDepthwiseConvolution2D.class);

    public KerasDepthwiseConvolution2D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasDepthwiseConvolution2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, Collections.emptyMap(), true);
    }

    public KerasDepthwiseConvolution2D(Map<String, Object> layerConfig, Map<String, ? extends KerasLayer> previousLayers) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, previousLayers, true);
    }

    public KerasDepthwiseConvolution2D(Map<String, Object> layerConfig, Map<String, ? extends KerasLayer> previousLayers, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, previousLayers, null, enforceTrainingConfig);
    }

    public KerasDepthwiseConvolution2D(Map<String, Object> layerConfig, Map<String, ? extends KerasLayer> previousLayers, List<String> layerNamesToCheck, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        if (layerNamesToCheck != null) {
            this.inboundLayerNames.addAll(layerNamesToCheck);
        }
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 2, this.conf, false);
        Pair<WeightInit, Distribution> depthWiseInit = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_DEPTH_WISE_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit depthWeightInit = (WeightInit)depthWiseInit.getFirst();
        Distribution depthDistribution = (Distribution)depthWiseInit.getSecond();
        long nIn = this.getNInFromConfig(previousLayers);
        int depthMultiplier = KerasConvolutionUtils.getDepthMultiplier(layerConfig, this.conf);
        this.weightL1Regularization = KerasRegularizerUtils.getWeightRegularizerFromConfig(layerConfig, this.conf, this.conf.getLAYER_FIELD_DEPTH_WISE_REGULARIZER(), this.conf.getREGULARIZATION_TYPE_L1());
        this.weightL2Regularization = KerasRegularizerUtils.getWeightRegularizerFromConfig(layerConfig, this.conf, this.conf.getLAYER_FIELD_DEPTH_WISE_REGULARIZER(), this.conf.getREGULARIZATION_TYPE_L2());
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint depthWiseWeightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_DEPTH_WISE_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        DepthwiseConvolution2D.Builder builder = ((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)((DepthwiseConvolution2D.Builder)new DepthwiseConvolution2D.Builder().name(this.layerName)).dropOut(this.dropout)).nIn(nIn)).nOut(nIn * (long)depthMultiplier)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(depthWeightInit.getWeightInitFunction(depthDistribution))).depthMultiplier(depthMultiplier).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 2, this.conf, this.kerasMajorVersion)).hasBias(this.hasBias)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 2, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 2, this.conf, this.kerasMajorVersion);
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding);
        }
        if (dilationRate != null) {
            builder.dilation(dilationRate);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (depthWiseWeightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{depthWiseWeightConstraint});
        }
        this.layer = builder.build();
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL())) {
            throw new InvalidKerasConfigurationException("Keras DepthwiseConvolution2D layer does not contain parameter " + this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL());
        }
        INDArray dW = weights.get(this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL());
        this.weights.put("W", dW);
        if (this.hasBias) {
            INDArray bias;
            if (this.kerasMajorVersion == 2 && weights.containsKey("bias")) {
                bias = weights.get("bias");
            } else if (this.kerasMajorVersion == 1 && weights.containsKey("b")) {
                bias = weights.get("b");
            } else {
                throw new InvalidKerasConfigurationException("Keras DepthwiseConvolution2D layer does not contain bias parameter");
            }
            this.weights.put("b", bias);
        }
    }

    public DepthwiseConvolution2D getDepthwiseConvolution2DLayer() {
        return (DepthwiseConvolution2D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras depth-wise convolution 2D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getDepthwiseConvolution2DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public String toString() {
        return "KerasDepthwiseConvolution2D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasDepthwiseConvolution2D)) {
            return false;
        }
        KerasDepthwiseConvolution2D other = (KerasDepthwiseConvolution2D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasDepthwiseConvolution2D;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

