/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.utils;

import java.util.Map;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;

public class KerasRegularizerUtils {
    public static double getWeightRegularizerFromConfig(Map<String, Object> layerConfig, KerasLayerConfiguration conf, String configField, String regularizerType) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        Map regularizerConfig;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (innerConfig.containsKey(configField) && (regularizerConfig = (Map)innerConfig.get(configField)) != null) {
            if (regularizerConfig.containsKey(regularizerType)) {
                return (Double)regularizerConfig.get(regularizerType);
            }
            if (regularizerConfig.containsKey(conf.getLAYER_FIELD_CLASS_NAME()) && regularizerConfig.get(conf.getLAYER_FIELD_CLASS_NAME()).equals("L1L2")) {
                Map<String, Object> innerRegularizerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(regularizerConfig, conf);
                try {
                    return (Double)innerRegularizerConfig.get(regularizerType);
                }
                catch (Exception e) {
                    return ((Integer)innerRegularizerConfig.get(regularizerType)).intValue();
                }
            }
        }
        return 0.0;
    }
}

