/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasZeroPadding
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasZeroPadding.class);
    public static final String LAYER_FIELD_PADDING = "padding";

    public KerasZeroPadding(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasZeroPadding(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        ZeroPaddingLayer.Builder builder = (ZeroPaddingLayer.Builder)((ZeroPaddingLayer.Builder)new ZeroPaddingLayer.Builder(this.getPaddingFromConfig(layerConfig)).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public ZeroPaddingLayer getZeroPaddingLayer() {
        return (ZeroPaddingLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras ZeroPadding layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getZeroPaddingLayer().getOutputType(-1, inputType[0]);
    }

    public int[] getPaddingFromConfig(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> innerConfig = KerasZeroPadding.getInnerLayerConfigFromConfig(layerConfig);
        if (!innerConfig.containsKey(LAYER_FIELD_PADDING)) {
            throw new InvalidKerasConfigurationException("Field padding not found in Keras ZeroPadding layer");
        }
        List paddingList = (List)innerConfig.get(LAYER_FIELD_PADDING);
        switch (this.className) {
            case "ZeroPadding2D": {
                if (paddingList.size() == 2) {
                    paddingList.add(paddingList.get(1));
                    paddingList.add(1, paddingList.get(0));
                }
                if (paddingList.size() == 4) break;
                throw new InvalidKerasConfigurationException("Found Keras ZeroPadding2D layer with invalid " + paddingList.size() + "D padding.");
            }
            case "ZeroPadding1D": {
                throw new UnsupportedKerasConfigurationException("Keras ZeroPadding1D layer not supported");
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Keras " + this.className + " padding layer not supported");
            }
        }
        int[] padding = new int[paddingList.size()];
        for (int i = 0; i < paddingList.size(); ++i) {
            padding[i] = (Integer)paddingList.get(i);
        }
        return padding;
    }
}

