/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.keras;

import java.nio.file.Path;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.hdf5;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayHDF5Reader {
    private hdf5.DataType dataType = new hdf5.DataType(hdf5.PredType.NATIVE_FLOAT());

    public INDArray readFromPath(Path inputFilePath) {
        try (hdf5.H5File h5File = new hdf5.H5File();){
            h5File.openFile(inputFilePath.toString(), hdf5.H5F_ACC_RDONLY);
            hdf5.DataSet dataSet = h5File.asCommonFG().openDataSet("data");
            int[] shape = this.extractShape(dataSet);
            long totalSize = ArrayUtil.prodLong((int[])shape);
            DataBuffer dataBuffer = this.readFromDataSet(dataSet, (int)totalSize);
            INDArray input = Nd4j.create((int[])shape);
            input.setData(dataBuffer);
            INDArray iNDArray = input;
            return iNDArray;
        }
    }

    private DataBuffer readFromDataSet(hdf5.DataSet dataSet, int total) {
        float[] dataBuffer = new float[total];
        FloatPointer fp = new FloatPointer(dataBuffer);
        dataSet.read((Pointer)fp, this.dataType);
        fp.get(dataBuffer);
        return Nd4j.createBuffer((float[])dataBuffer);
    }

    private int[] extractShape(hdf5.DataSet dataSet) {
        hdf5.DataSpace space = dataSet.getSpace();
        int nbDims = space.getSimpleExtentNdims();
        long[] shape = new long[nbDims];
        space.getSimpleExtentDims(shape);
        return ArrayUtil.toInts((long[])shape);
    }
}

