/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.keras;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.deeplearning4j.keras.NDArrayHDF5Reader;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDF5MiniBatchDataSetIterator
implements DataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(HDF5MiniBatchDataSetIterator.class);
    private static final String FILE_NAME_PATTERN = "batch_%d.h5";
    private final NDArrayHDF5Reader ndArrayHDF5Reader = new NDArrayHDF5Reader();
    private final File trainFeaturesDirectory;
    private final File trainLabelsDirectory;
    private final int batchesCount;
    private int currentIdx;
    private DataSetPreProcessor preProcessor;

    public HDF5MiniBatchDataSetIterator(String trainFeaturesDirectory, String trainLabelsDirectory) {
        this.trainFeaturesDirectory = new File(trainFeaturesDirectory);
        this.trainLabelsDirectory = new File(trainLabelsDirectory);
        this.batchesCount = this.trainFeaturesDirectory.list().length;
    }

    public boolean hasNext() {
        return this.currentIdx < this.batchesCount;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet dataSet = this.readIdx(this.currentIdx);
        ++this.currentIdx;
        if (this.preProcessor != null && !dataSet.isPreProcessed()) {
            this.preProcessor.preProcess((DataSet)dataSet);
            dataSet.markAsPreProcessed();
        }
        return dataSet;
    }

    private org.nd4j.linalg.dataset.DataSet readIdx(int currentIdx) {
        String batchFileName = this.fileNameForIdx(currentIdx);
        if (log.isTraceEnabled()) {
            log.trace("Reading: " + batchFileName);
        }
        INDArray features = this.ndArrayHDF5Reader.readFromPath(Paths.get(this.trainFeaturesDirectory.getAbsolutePath(), batchFileName));
        INDArray labels = this.ndArrayHDF5Reader.readFromPath(Paths.get(this.trainLabelsDirectory.getAbsolutePath(), batchFileName));
        return new org.nd4j.linalg.dataset.DataSet(features, labels);
    }

    private String fileNameForIdx(int currentIdx) {
        return String.format(FILE_NAME_PATTERN, currentIdx);
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public void reset() {
        this.currentIdx = 0;
    }

    public int cursor() {
        return this.currentIdx;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        throw new UnsupportedOperationException("Can't load custom number of samples");
    }

    public int totalExamples() {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        throw new UnsupportedOperationException();
    }

    public int totalOutcomes() {
        throw new UnsupportedOperationException();
    }

    public int batch() {
        throw new UnsupportedOperationException();
    }

    public int numExamples() {
        throw new UnsupportedOperationException();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public List<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
    }
}

