/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.iterator;

import java.util.NoSuchElementException;
import java.util.Random;
import org.deeplearning4j.graph.api.IGraph;
import org.deeplearning4j.graph.api.IVertexSequence;
import org.deeplearning4j.graph.api.NoEdgeHandling;
import org.deeplearning4j.graph.api.Vertex;
import org.deeplearning4j.graph.exception.NoEdgesException;
import org.deeplearning4j.graph.graph.VertexSequence;
import org.deeplearning4j.graph.iterator.GraphWalkIterator;

public class RandomWalkIterator<V>
implements GraphWalkIterator<V> {
    private final IGraph<V, ?> graph;
    private final int walkLength;
    private final NoEdgeHandling mode;
    private final int firstVertex;
    private final int lastVertex;
    private int position;
    private Random rng;
    private int[] order;

    public RandomWalkIterator(IGraph<V, ?> graph, int walkLength) {
        this(graph, walkLength, System.currentTimeMillis(), NoEdgeHandling.EXCEPTION_ON_DISCONNECTED);
    }

    public RandomWalkIterator(IGraph<V, ?> graph, int walkLength, long rngSeed) {
        this(graph, walkLength, rngSeed, NoEdgeHandling.EXCEPTION_ON_DISCONNECTED);
    }

    public RandomWalkIterator(IGraph<V, ?> graph, int walkLength, long rngSeed, NoEdgeHandling mode) {
        this(graph, walkLength, rngSeed, mode, 0, graph.numVertices());
    }

    public RandomWalkIterator(IGraph<V, ?> graph, int walkLength, long rngSeed, NoEdgeHandling mode, int firstVertex, int lastVertex) {
        this.graph = graph;
        this.walkLength = walkLength;
        this.rng = new Random(rngSeed);
        this.mode = mode;
        this.firstVertex = firstVertex;
        this.lastVertex = lastVertex;
        this.order = new int[lastVertex - firstVertex];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = firstVertex + i;
        }
        this.reset();
    }

    @Override
    public IVertexSequence<V> next() {
        Vertex<V> next;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int currVertexIdx = this.order[this.position++];
        int[] indices = new int[this.walkLength + 1];
        indices[0] = currVertexIdx;
        if (this.walkLength == 0) {
            return new VertexSequence<V>(this.graph, indices);
        }
        try {
            next = this.graph.getRandomConnectedVertex(currVertexIdx, this.rng);
        }
        catch (NoEdgesException e) {
            switch (this.mode) {
                case SELF_LOOP_ON_DISCONNECTED: {
                    for (int i = 1; i < this.walkLength; ++i) {
                        indices[i] = currVertexIdx;
                    }
                    return new VertexSequence<V>(this.graph, indices);
                }
                case EXCEPTION_ON_DISCONNECTED: {
                    throw e;
                }
            }
            throw new RuntimeException("Unknown/not implemented NoEdgeHandling mode: " + (Object)((Object)this.mode));
        }
        indices[1] = next.vertexID();
        currVertexIdx = indices[1];
        for (int i = 2; i <= this.walkLength; ++i) {
            next = this.graph.getRandomConnectedVertex(currVertexIdx, this.rng);
            indices[i] = currVertexIdx = next.vertexID();
        }
        return new VertexSequence<V>(this.graph, indices);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.order.length;
    }

    @Override
    public void reset() {
        this.position = 0;
        for (int i = this.order.length - 1; i > 0; --i) {
            int j = this.rng.nextInt(i + 1);
            int temp = this.order[j];
            this.order[j] = this.order[i];
            this.order[i] = temp;
        }
    }

    @Override
    public int walkLength() {
        return this.walkLength;
    }
}

