/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.deeplearning4j.graph.api.Edge;
import org.deeplearning4j.graph.api.Vertex;
import org.deeplearning4j.graph.data.EdgeLineProcessor;
import org.deeplearning4j.graph.data.VertexLoader;
import org.deeplearning4j.graph.data.impl.DelimitedEdgeLineProcessor;
import org.deeplearning4j.graph.data.impl.WeightedEdgeLineProcessor;
import org.deeplearning4j.graph.graph.Graph;
import org.deeplearning4j.graph.vertexfactory.StringVertexFactory;
import org.deeplearning4j.graph.vertexfactory.VertexFactory;

public class GraphLoader {
    public static Graph<String, String> loadUndirectedGraphEdgeListFile(String path, int numVertices, String delim) throws IOException {
        Graph<String, String> graph = new Graph<String, String>(numVertices, false, new StringVertexFactory());
        DelimitedEdgeLineProcessor lineProcessor = new DelimitedEdgeLineProcessor(delim, false);
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                Edge edge = lineProcessor.processLine(line);
                if (edge == null) continue;
                graph.addEdge(edge);
            }
        }
        return graph;
    }

    public static Graph<String, Double> loadWeightedEdgeListFile(String path, int numVertices, String delim, boolean directed, String ... ignoreLinesStartingWith) throws IOException {
        Graph<String, Double> graph = new Graph<String, Double>(numVertices, false, new StringVertexFactory());
        WeightedEdgeLineProcessor lineProcessor = new WeightedEdgeLineProcessor(delim, directed, ignoreLinesStartingWith);
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                Edge edge = lineProcessor.processLine(line);
                if (edge == null) continue;
                graph.addEdge(edge);
            }
        }
        return graph;
    }

    public static <V, E> Graph<V, E> loadGraph(String path, EdgeLineProcessor<E> lineProcessor, VertexFactory<V> vertexFactory, int numVertices, boolean allowMultipleEdges) throws IOException {
        Graph<V, E> graph = new Graph<V, E>(numVertices, allowMultipleEdges, vertexFactory);
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                Edge<E> edge = lineProcessor.processLine(line);
                if (edge == null) continue;
                graph.addEdge(edge);
            }
        }
        return graph;
    }

    public static <V, E> Graph<V, E> loadGraph(String vertexFilePath, String edgeFilePath, VertexLoader<V> vertexLoader, EdgeLineProcessor<E> edgeLineProcessor, boolean allowMultipleEdges) throws IOException {
        List<Vertex<V>> vertices = vertexLoader.loadVertices(vertexFilePath);
        Graph<V, E> graph = new Graph<V, E>(vertices, allowMultipleEdges);
        try (BufferedReader br = new BufferedReader(new FileReader(new File(edgeFilePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                Edge<E> edge = edgeLineProcessor.processLine(line);
                if (edge == null) continue;
                graph.addEdge(edge);
            }
        }
        return graph;
    }
}

