/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.datavec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataComposableMap;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.batch.NDArrayRecordBatch;
import org.deeplearning4j.datasets.datavec.exception.ZeroLengthSequenceException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class RecordReaderMultiDataSetIterator
implements MultiDataSetIterator,
Serializable {
    private int batchSize;
    private AlignmentMode alignmentMode;
    private Map<String, RecordReader> recordReaders = new HashMap<String, RecordReader>();
    private Map<String, SequenceRecordReader> sequenceRecordReaders = new HashMap<String, SequenceRecordReader>();
    private List<SubsetDetails> inputs = new ArrayList<SubsetDetails>();
    private List<SubsetDetails> outputs = new ArrayList<SubsetDetails>();
    private boolean collectMetaData = false;
    private boolean timeSeriesRandomOffset = false;
    private Random timeSeriesRandomOffsetRng;
    private MultiDataSetPreProcessor preProcessor;
    private boolean resetSupported = true;

    private RecordReaderMultiDataSetIterator(Builder builder) {
        this.batchSize = builder.batchSize;
        this.alignmentMode = builder.alignmentMode;
        this.recordReaders = builder.recordReaders;
        this.sequenceRecordReaders = builder.sequenceRecordReaders;
        this.inputs.addAll(builder.inputs);
        this.outputs.addAll(builder.outputs);
        this.timeSeriesRandomOffset = builder.timeSeriesRandomOffset;
        if (this.timeSeriesRandomOffset) {
            this.timeSeriesRandomOffsetRng = new Random(builder.timeSeriesRandomOffsetSeed);
        }
        if (this.recordReaders != null) {
            for (RecordReader rr : this.recordReaders.values()) {
                this.resetSupported &= rr.resetSupported();
            }
        }
        if (this.sequenceRecordReaders != null) {
            for (SequenceRecordReader srr : this.sequenceRecordReaders.values()) {
                this.resetSupported &= srr.resetSupported();
            }
        }
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        return this.next(this.batchSize);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        ArrayList<List> writables;
        RecordReader rr;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next elements");
        }
        HashMap<String, List<List<Writable>>> nextRRVals = new HashMap<String, List<List<Writable>>>();
        HashMap nextRRValsBatched = null;
        HashMap<String, List<List<List<Writable>>>> nextSeqRRVals = new HashMap<String, List<List<List<Writable>>>>();
        ArrayList<RecordMetaDataComposableMap> nextMetas = this.collectMetaData ? new ArrayList<RecordMetaDataComposableMap>() : null;
        for (Map.Entry<String, RecordReader> entry : this.recordReaders.entrySet()) {
            rr = entry.getValue();
            if (!this.collectMetaData && rr.batchesSupported()) {
                ArrayList<INDArray> batch;
                List<List<Writable>> batchWritables = rr.next(num);
                if (batchWritables instanceof NDArrayRecordBatch) {
                    batch = ((NDArrayRecordBatch)batchWritables).getArrays();
                } else {
                    batchWritables = this.filterRequiredColumns(entry.getKey(), batchWritables);
                    batch = new ArrayList<INDArray>();
                    ArrayList<Writable> temp = new ArrayList<Writable>();
                    int sz = batchWritables.get(0).size();
                    for (int i = 0; i < sz; ++i) {
                        temp.clear();
                        for (int j = 0; j < batchWritables.size(); ++j) {
                            temp.add(batchWritables.get(j).get(i));
                        }
                        batch.add(RecordConverter.toMinibatchArray(temp));
                    }
                }
                if (nextRRValsBatched == null) {
                    nextRRValsBatched = new HashMap();
                }
                nextRRValsBatched.put(entry.getKey(), batch);
                continue;
            }
            writables = new ArrayList<List>(num);
            for (int i = 0; i < num && rr.hasNext(); ++i) {
                List record;
                if (this.collectMetaData) {
                    Record r = rr.nextRecord();
                    record = r.getRecord();
                    if (nextMetas.size() <= i) {
                        nextMetas.add(new RecordMetaDataComposableMap(new HashMap()));
                    }
                    RecordMetaDataComposableMap map = (RecordMetaDataComposableMap)nextMetas.get(i);
                    map.getMeta().put(entry.getKey(), r.getMetaData());
                } else {
                    record = rr.next();
                }
                writables.add(record);
            }
            nextRRVals.put(entry.getKey(), writables);
        }
        for (Map.Entry<String, RecordReader> entry : this.sequenceRecordReaders.entrySet()) {
            rr = (SequenceRecordReader)entry.getValue();
            writables = new ArrayList(num);
            for (int i = 0; i < num && rr.hasNext(); ++i) {
                List sequence;
                if (this.collectMetaData) {
                    SequenceRecord r = rr.nextSequence();
                    sequence = r.getSequenceRecord();
                    if (nextMetas.size() <= i) {
                        nextMetas.add(new RecordMetaDataComposableMap(new HashMap()));
                    }
                    RecordMetaDataComposableMap map = (RecordMetaDataComposableMap)nextMetas.get(i);
                    map.getMeta().put(entry.getKey(), r.getMetaData());
                } else {
                    sequence = rr.sequenceRecord();
                }
                writables.add(sequence);
            }
            nextSeqRRVals.put(entry.getKey(), writables);
        }
        return this.nextMultiDataSet(nextRRVals, nextRRValsBatched, nextSeqRRVals, nextMetas);
    }

    private List<List<Writable>> filterRequiredColumns(String readerName, List<List<Writable>> list) {
        boolean entireReader = false;
        ArrayList<SubsetDetails> subsetList = null;
        int max = -1;
        int min = Integer.MAX_VALUE;
        block0: for (List list2 : Arrays.asList(this.inputs, this.outputs)) {
            for (SubsetDetails sd : list2) {
                if (!readerName.equals(sd.readerName)) continue;
                if (sd.entireReader) {
                    entireReader = true;
                    continue block0;
                }
                if (subsetList == null) {
                    subsetList = new ArrayList<SubsetDetails>();
                }
                subsetList.add(sd);
                max = Math.max(max, sd.subsetEndInclusive);
                min = Math.min(min, sd.subsetStart);
            }
        }
        if (entireReader) {
            return list;
        }
        if (subsetList == null) {
            throw new IllegalStateException("Found no usages of reader: " + readerName);
        }
        boolean[] req = new boolean[max + 1];
        for (SubsetDetails sd : subsetList) {
            for (int i = sd.subsetStart; i <= sd.subsetEndInclusive; ++i) {
                req[i] = true;
            }
        }
        ArrayList<List<Writable>> arrayList = new ArrayList<List<Writable>>();
        IntWritable zero = new IntWritable(0);
        for (List<Writable> l : list) {
            ArrayList<Object> lNew = new ArrayList<Object>(l.size());
            for (int i = 0; i < l.size(); ++i) {
                if (i >= req.length || !req[i]) {
                    lNew.add(zero);
                    continue;
                }
                lNew.add(l.get(i));
            }
            arrayList.add(lNew);
        }
        return arrayList;
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet nextMultiDataSet(Map<String, List<List<Writable>>> nextRRVals, Map<String, List<INDArray>> nextRRValsBatched, Map<String, List<List<List<Writable>>>> nextSeqRRVals, List<RecordMetaDataComposableMap> nextMetas) {
        int n;
        int minExamples = Integer.MAX_VALUE;
        for (List<List<Writable>> list : nextRRVals.values()) {
            minExamples = Math.min(minExamples, list.size());
        }
        if (nextRRValsBatched != null) {
            for (List<List<Object>> list : nextRRValsBatched.values()) {
                for (INDArray iNDArray : list) {
                    int n2 = iNDArray.size(0);
                    minExamples = Math.min(minExamples, n2);
                }
            }
        }
        for (List<List<Object>> list : nextSeqRRVals.values()) {
            minExamples = Math.min(minExamples, list.size());
        }
        if (minExamples == Integer.MAX_VALUE) {
            throw new RuntimeException("Error occurred during data set generation: no readers?");
        }
        int[] longestSequence = null;
        if (this.timeSeriesRandomOffset || this.alignmentMode == AlignmentMode.ALIGN_END) {
            longestSequence = new int[minExamples];
            for (Map.Entry<String, List<List<List<Writable>>>> entry : nextSeqRRVals.entrySet()) {
                List<List<List<Writable>>> list = entry.getValue();
                for (int i = 0; i < list.size() && i < minExamples; ++i) {
                    longestSequence[i] = Math.max(longestSequence[i], list.get(i).size());
                }
            }
        }
        int n3 = -1;
        if (this.alignmentMode != AlignmentMode.EQUAL_LENGTH) {
            for (Map.Entry<String, List<List<List<Writable>>>> entry : nextSeqRRVals.entrySet()) {
                List<List<List<Writable>>> list = entry.getValue();
                for (List<List<Writable>> c : list) {
                    n = Math.max(n, c.size());
                }
            }
        }
        long l = this.timeSeriesRandomOffset ? this.timeSeriesRandomOffsetRng.nextLong() : -1L;
        Pair<INDArray[], INDArray[]> features = this.convertFeaturesOrLabels(new INDArray[this.inputs.size()], new INDArray[this.inputs.size()], this.inputs, minExamples, nextRRVals, nextRRValsBatched, nextSeqRRVals, n, longestSequence, l);
        Pair<INDArray[], INDArray[]> labels = this.convertFeaturesOrLabels(new INDArray[this.outputs.size()], new INDArray[this.outputs.size()], this.outputs, minExamples, nextRRVals, nextRRValsBatched, nextSeqRRVals, n, longestSequence, l);
        MultiDataSet mds = new MultiDataSet((INDArray[])features.getFirst(), (INDArray[])labels.getFirst(), (INDArray[])features.getSecond(), (INDArray[])labels.getSecond());
        if (this.collectMetaData) {
            mds.setExampleMetaData(nextMetas);
        }
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((org.nd4j.linalg.dataset.api.MultiDataSet)mds);
        }
        return mds;
    }

    private Pair<INDArray[], INDArray[]> convertFeaturesOrLabels(INDArray[] featuresOrLabels, INDArray[] masks, List<SubsetDetails> subsetDetails, int minExamples, Map<String, List<List<Writable>>> nextRRVals, Map<String, List<INDArray>> nextRRValsBatched, Map<String, List<List<List<Writable>>>> nextSeqRRVals, int longestTS, int[] longestSequence, long rngSeed) {
        boolean hasMasks = false;
        int i = 0;
        for (SubsetDetails d : subsetDetails) {
            List<List<List<Writable>>> list;
            if (nextRRValsBatched != null && nextRRValsBatched.containsKey(d.readerName)) {
                featuresOrLabels[i] = this.convertWritablesBatched(nextRRValsBatched.get(d.readerName), d);
            } else if (nextRRVals.containsKey(d.readerName)) {
                list = nextRRVals.get(d.readerName);
                featuresOrLabels[i] = this.convertWritables(list, minExamples, d);
            } else {
                list = nextSeqRRVals.get(d.readerName);
                Pair<INDArray, INDArray> p = this.convertWritablesSequence(list, minExamples, longestTS, d, longestSequence, rngSeed);
                featuresOrLabels[i] = (INDArray)p.getFirst();
                masks[i] = (INDArray)p.getSecond();
                if (masks[i] != null) {
                    hasMasks = true;
                }
            }
            ++i;
        }
        return new Pair((Object)featuresOrLabels, hasMasks ? masks : null);
    }

    private INDArray convertWritablesBatched(List<INDArray> list, SubsetDetails details) {
        INDArray arr;
        if (details.entireReader) {
            if (list.size() == 1) {
                arr = list.get(0);
            } else {
                INDArray[] asArray = list.toArray(new INDArray[list.size()]);
                arr = Nd4j.concat((int)1, (INDArray[])asArray);
            }
        } else if (details.subsetStart == details.subsetEndInclusive || details.oneHot) {
            arr = list.get(details.subsetStart);
        } else {
            int count = details.subsetEndInclusive - details.subsetStart + 1;
            INDArray[] temp = new INDArray[count];
            int x = 0;
            for (int i = details.subsetStart; i <= details.subsetEndInclusive; ++i) {
                temp[x++] = list.get(i);
            }
            arr = Nd4j.concat((int)1, (INDArray[])temp);
        }
        if (!details.oneHot || arr.size(1) == details.oneHotNumClasses) {
            return arr;
        }
        if (arr.size(1) != 1) {
            throw new UnsupportedOperationException("Cannot do conversion to one hot using batched reader: " + details.oneHotNumClasses + " output classes, but array.size(1) is " + arr.size(1) + " (must be equal to 1 or numClasses = " + details.oneHotNumClasses + ")");
        }
        int n = arr.size(0);
        INDArray out = Nd4j.create((int)n, (int)details.oneHotNumClasses);
        for (int i = 0; i < n; ++i) {
            int v = arr.getInt(new int[]{i, 0});
            out.putScalar(i, v, 1.0);
        }
        return out;
    }

    private int countLength(List<Writable> list) {
        return this.countLength(list, 0, list.size() - 1);
    }

    private int countLength(List<Writable> list, int from, int to) {
        int length = 0;
        for (int i = from; i <= to; ++i) {
            Writable w = list.get(i);
            if (w instanceof NDArrayWritable) {
                INDArray a = ((NDArrayWritable)w).get();
                if (!a.isRowVectorOrScalar()) {
                    throw new UnsupportedOperationException("Multiple writables present but NDArrayWritable is not a row vector. Can only concat row vectors with other writables. Shape: " + Arrays.toString(a.shape()));
                }
                length += a.length();
                continue;
            }
            ++length;
        }
        return length;
    }

    private INDArray convertWritables(List<List<Writable>> list, int minValues, SubsetDetails details) {
        try {
            return this.convertWritablesHelper(list, minValues, details);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing data (writables) from record readers - value is non-numeric", e);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error parsing data (writables) from record readers", t);
        }
    }

    private INDArray convertWritablesHelper(List<List<Writable>> list, int minValues, SubsetDetails details) {
        INDArray arr;
        int[] shape;
        if (details.entireReader) {
            if (list.get(0).size() == 1 && list.get(0).get(0) instanceof NDArrayWritable) {
                INDArray temp = ((NDArrayWritable)list.get(0).get(0)).get();
                shape = ArrayUtils.clone((int[])temp.shape());
                shape[0] = minValues;
                arr = Nd4j.create((int[])shape);
            } else {
                arr = Nd4j.create((int)minValues, (int)this.countLength(list.get(0)));
            }
        } else if (details.oneHot) {
            arr = Nd4j.zeros((int)minValues, (int)details.oneHotNumClasses);
        } else if (details.subsetStart == details.subsetEndInclusive && list.get(0).get(details.subsetStart) instanceof NDArrayWritable) {
            INDArray temp = ((NDArrayWritable)list.get(0).get(details.subsetStart)).get();
            shape = ArrayUtils.clone((int[])temp.shape());
            shape[0] = minValues;
            arr = Nd4j.create((int[])shape);
        } else {
            int length = this.countLength(list.get(0), details.subsetStart, details.subsetEndInclusive);
            arr = Nd4j.create((int)minValues, (int)length);
        }
        for (int i = 0; i < minValues; ++i) {
            List<Writable> c = list.get(i);
            if (details.entireReader) {
                INDArray converted = RecordConverter.toArray(c);
                this.putExample(arr, converted, i);
                continue;
            }
            if (details.oneHot) {
                Writable w = c.get(details.subsetStart);
                int classIdx = w.toInt();
                if (classIdx >= details.oneHotNumClasses) {
                    throw new IllegalStateException("Cannot convert sequence writables to one-hot: class index " + classIdx + " >= numClass (" + details.oneHotNumClasses + "). (Note that classes are zero-indexed, thus only values 0 to nClasses-1 are valid)");
                }
                arr.putScalar(i, w.toInt(), 1.0);
                continue;
            }
            if (details.subsetStart == details.subsetEndInclusive && c.get(details.subsetStart) instanceof NDArrayWritable) {
                this.putExample(arr, ((NDArrayWritable)c.get(details.subsetStart)).get(), i);
                continue;
            }
            Iterator<Writable> iter = c.iterator();
            for (int j = 0; j < details.subsetStart; ++j) {
                iter.next();
            }
            int k = 0;
            for (int j = details.subsetStart; j <= details.subsetEndInclusive; ++j) {
                Writable w = iter.next();
                if (w instanceof NDArrayWritable) {
                    INDArray toPut = ((NDArrayWritable)w).get();
                    arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.interval((int)k, (int)(k + toPut.length()))}, toPut);
                    k += toPut.length();
                    continue;
                }
                arr.putScalar(i, k, w.toDouble());
                ++k;
            }
        }
        return arr;
    }

    private void putExample(INDArray arr, INDArray singleExample, int exampleIdx) {
        switch (arr.rank()) {
            case 2: {
                arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)exampleIdx), NDArrayIndex.all()}, singleExample);
                break;
            }
            case 3: {
                arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)exampleIdx), NDArrayIndex.all(), NDArrayIndex.all()}, singleExample);
                break;
            }
            case 4: {
                arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)exampleIdx), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}, singleExample);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected rank: " + arr.rank());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<INDArray, INDArray> convertWritablesSequence(List<List<List<Writable>>> list, int minValues, int maxTSLength, SubsetDetails details, int[] longestSequence, long rngSeed) {
        void var12_18;
        if (maxTSLength == -1) {
            maxTSLength = list.get(0).size();
        }
        if (list.get(0).isEmpty()) {
            throw new ZeroLengthSequenceException("Zero length sequence encountered");
        }
        List<Writable> firstStep = list.get(0).get(0);
        int size = 0;
        if (details.entireReader) {
            for (Writable writable : firstStep) {
                if (writable instanceof NDArrayWritable) {
                    size += ((NDArrayWritable)writable).get().size(1);
                    continue;
                }
                ++size;
            }
        } else if (details.oneHot) {
            size = details.oneHotNumClasses;
        } else {
            for (int i = details.subsetStart; i <= details.subsetEndInclusive; ++i) {
                Writable writable = firstStep.get(i);
                if (writable instanceof NDArrayWritable) {
                    size += ((NDArrayWritable)writable).get().size(1);
                    continue;
                }
                ++size;
            }
        }
        INDArray arr = Nd4j.create((int[])new int[]{minValues, size, maxTSLength}, (char)'f');
        boolean needMaskArray = false;
        for (List<List<Writable>> list2 : list) {
            if (list2.size() >= maxTSLength) continue;
            needMaskArray = true;
        }
        if (needMaskArray && this.alignmentMode == AlignmentMode.EQUAL_LENGTH) {
            throw new UnsupportedOperationException("Alignment mode is set to EQUAL_LENGTH but variable length data was encountered. Use AlignmentMode.ALIGN_START or AlignmentMode.ALIGN_END with variable length data");
        }
        if (needMaskArray) {
            INDArray iNDArray = Nd4j.ones((int)minValues, (int)maxTSLength);
        } else {
            Object var12_17 = null;
        }
        Object var13_21 = null;
        if (this.timeSeriesRandomOffset) {
            Random random = new Random(rngSeed);
        }
        for (int i = 0; i < minValues; ++i) {
            List<List<Writable>> sequence = list.get(i);
            int startOffset = this.alignmentMode == AlignmentMode.ALIGN_START || this.alignmentMode == AlignmentMode.EQUAL_LENGTH ? 0 : longestSequence[i] - sequence.size();
            if (this.timeSeriesRandomOffset) {
                void var13_23;
                int maxPossible = maxTSLength - sequence.size() + 1;
                startOffset = var13_23.nextInt(maxPossible);
            }
            int t = 0;
            for (List<Writable> timeStep : sequence) {
                INDArray row;
                int j;
                int k = startOffset + t++;
                if (details.entireReader) {
                    Iterator<Writable> iter = timeStep.iterator();
                    j = 0;
                    while (iter.hasNext()) {
                        Writable w = iter.next();
                        if (w instanceof NDArrayWritable) {
                            row = ((NDArrayWritable)w).get();
                            arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.interval((int)j, (int)(j + row.length())), NDArrayIndex.point((int)k)}, row);
                            j += row.length();
                            continue;
                        }
                        arr.putScalar(i, j, k, w.toDouble());
                        ++j;
                    }
                    continue;
                }
                if (details.oneHot) {
                    Writable w = null;
                    if (timeStep instanceof List) {
                        w = timeStep.get(details.subsetStart);
                    } else {
                        Iterator<Writable> iter = timeStep.iterator();
                        for (int x = 0; x <= details.subsetStart; ++x) {
                            w = iter.next();
                        }
                    }
                    int classIdx = w.toInt();
                    if (classIdx >= details.oneHotNumClasses) {
                        throw new IllegalStateException("Cannot convert sequence writables to one-hot: class index " + classIdx + " >= numClass (" + details.oneHotNumClasses + "). (Note that classes are zero-indexed, thus only values 0 to nClasses-1 are valid)");
                    }
                    arr.putScalar(i, classIdx, k, 1.0);
                    continue;
                }
                int l = 0;
                for (j = details.subsetStart; j <= details.subsetEndInclusive; ++j) {
                    Writable w = timeStep.get(j);
                    if (w instanceof NDArrayWritable) {
                        row = ((NDArrayWritable)w).get();
                        arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.interval((int)l, (int)(l + row.length())), NDArrayIndex.point((int)k)}, row);
                        l += row.length();
                        continue;
                    }
                    arr.putScalar(i, l++, k, w.toDouble());
                }
            }
            if (!needMaskArray) continue;
            if (this.timeSeriesRandomOffset || this.alignmentMode == AlignmentMode.ALIGN_END) {
                for (int t2 = 0; t2 < startOffset; ++t2) {
                    var12_18.putScalar(i, t2, 0.0);
                }
            }
            int lastStep = startOffset + sequence.size();
            if (!this.timeSeriesRandomOffset && this.alignmentMode != AlignmentMode.ALIGN_START && lastStep >= maxTSLength) continue;
            for (int t2 = lastStep; t2 < maxTSLength; ++t2) {
                var12_18.putScalar(i, t2, 0.0);
            }
        }
        return new Pair((Object)arr, (Object)var12_18);
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public boolean resetSupported() {
        return this.resetSupported;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (!this.resetSupported) {
            throw new IllegalStateException("Cannot reset iterator - reset not supported (resetSupported() == false): one or more underlying (sequence) record readers do not support resetting");
        }
        for (RecordReader recordReader : this.recordReaders.values()) {
            recordReader.reset();
        }
        for (SequenceRecordReader sequenceRecordReader : this.sequenceRecordReaders.values()) {
            sequenceRecordReader.reset();
        }
    }

    public boolean hasNext() {
        for (RecordReader recordReader : this.recordReaders.values()) {
            if (recordReader.hasNext()) continue;
            return false;
        }
        for (SequenceRecordReader sequenceRecordReader : this.sequenceRecordReaders.values()) {
            if (sequenceRecordReader.hasNext()) continue;
            return false;
        }
        return true;
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData));
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet loadFromMetaData(List<RecordMetaData> list) throws IOException {
        Record r;
        ArrayList<List> writables;
        Object fromMeta;
        Object m2;
        ArrayList thisRRMeta;
        RecordReader rr;
        HashMap<String, List<List<Writable>>> nextRRVals = new HashMap<String, List<List<Writable>>>();
        HashMap<String, List<List<List<Writable>>>> nextSeqRRVals = new HashMap<String, List<List<List<Writable>>>>();
        ArrayList<RecordMetaDataComposableMap> nextMetas = this.collectMetaData ? new ArrayList<RecordMetaDataComposableMap>() : null;
        for (Map.Entry<String, RecordReader> entry : this.recordReaders.entrySet()) {
            rr = entry.getValue();
            thisRRMeta = new ArrayList();
            for (RecordMetaData m : list) {
                m2 = (RecordMetaDataComposableMap)m;
                thisRRMeta.add(m2.getMeta().get(entry.getKey()));
            }
            fromMeta = rr.loadFromMetaData(thisRRMeta);
            writables = new ArrayList<List>(list.size());
            m2 = fromMeta.iterator();
            while (m2.hasNext()) {
                r = (Record)m2.next();
                writables.add(r.getRecord());
            }
            nextRRVals.put(entry.getKey(), writables);
        }
        for (Map.Entry<String, RecordReader> entry : this.sequenceRecordReaders.entrySet()) {
            rr = (SequenceRecordReader)entry.getValue();
            thisRRMeta = new ArrayList();
            for (RecordMetaData m : list) {
                m2 = (RecordMetaDataComposableMap)m;
                thisRRMeta.add(m2.getMeta().get(entry.getKey()));
            }
            fromMeta = rr.loadSequenceFromMetaData(thisRRMeta);
            writables = new ArrayList(list.size());
            Iterator iterator = fromMeta.iterator();
            while (iterator.hasNext()) {
                r = (SequenceRecord)iterator.next();
                writables.add(r.getSequenceRecord());
            }
            nextSeqRRVals.put(entry.getKey(), writables);
        }
        return this.nextMultiDataSet(nextRRVals, null, nextSeqRRVals, nextMetas);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public AlignmentMode getAlignmentMode() {
        return this.alignmentMode;
    }

    public Map<String, RecordReader> getRecordReaders() {
        return this.recordReaders;
    }

    public Map<String, SequenceRecordReader> getSequenceRecordReaders() {
        return this.sequenceRecordReaders;
    }

    public List<SubsetDetails> getInputs() {
        return this.inputs;
    }

    public List<SubsetDetails> getOutputs() {
        return this.outputs;
    }

    public boolean isTimeSeriesRandomOffset() {
        return this.timeSeriesRandomOffset;
    }

    public Random getTimeSeriesRandomOffsetRng() {
        return this.timeSeriesRandomOffsetRng;
    }

    public boolean isResetSupported() {
        return this.resetSupported;
    }

    public boolean isCollectMetaData() {
        return this.collectMetaData;
    }

    public void setCollectMetaData(boolean collectMetaData) {
        this.collectMetaData = collectMetaData;
    }

    private static class SubsetDetails
    implements Serializable {
        private final String readerName;
        private final boolean entireReader;
        private final boolean oneHot;
        private final int oneHotNumClasses;
        private final int subsetStart;
        private final int subsetEndInclusive;

        public SubsetDetails(String readerName, boolean entireReader, boolean oneHot, int oneHotNumClasses, int subsetStart, int subsetEndInclusive) {
            this.readerName = readerName;
            this.entireReader = entireReader;
            this.oneHot = oneHot;
            this.oneHotNumClasses = oneHotNumClasses;
            this.subsetStart = subsetStart;
            this.subsetEndInclusive = subsetEndInclusive;
        }
    }

    public static class Builder {
        private int batchSize;
        private AlignmentMode alignmentMode = AlignmentMode.ALIGN_START;
        private Map<String, RecordReader> recordReaders = new HashMap<String, RecordReader>();
        private Map<String, SequenceRecordReader> sequenceRecordReaders = new HashMap<String, SequenceRecordReader>();
        private List<SubsetDetails> inputs = new ArrayList<SubsetDetails>();
        private List<SubsetDetails> outputs = new ArrayList<SubsetDetails>();
        private boolean timeSeriesRandomOffset = false;
        private long timeSeriesRandomOffsetSeed = System.currentTimeMillis();

        public Builder(int batchSize) {
            this.batchSize = batchSize;
        }

        public Builder addReader(String readerName, RecordReader recordReader) {
            this.recordReaders.put(readerName, recordReader);
            return this;
        }

        public Builder addSequenceReader(String seqReaderName, SequenceRecordReader seqRecordReader) {
            this.sequenceRecordReaders.put(seqReaderName, seqRecordReader);
            return this;
        }

        public Builder sequenceAlignmentMode(AlignmentMode alignmentMode) {
            this.alignmentMode = alignmentMode;
            return this;
        }

        public Builder addInput(String readerName) {
            this.inputs.add(new SubsetDetails(readerName, true, false, -1, -1, -1));
            return this;
        }

        public Builder addInput(String readerName, int columnFirst, int columnLast) {
            this.inputs.add(new SubsetDetails(readerName, false, false, -1, columnFirst, columnLast));
            return this;
        }

        public Builder addInputOneHot(String readerName, int column, int numClasses) {
            this.inputs.add(new SubsetDetails(readerName, false, true, numClasses, column, column));
            return this;
        }

        public Builder addOutput(String readerName) {
            this.outputs.add(new SubsetDetails(readerName, true, false, -1, -1, -1));
            return this;
        }

        public Builder addOutput(String readerName, int columnFirst, int columnLast) {
            this.outputs.add(new SubsetDetails(readerName, false, false, -1, columnFirst, columnLast));
            return this;
        }

        public Builder addOutputOneHot(String readerName, int column, int numClasses) {
            this.outputs.add(new SubsetDetails(readerName, false, true, numClasses, column, column));
            return this;
        }

        public Builder timeSeriesRandomOffset(boolean timeSeriesRandomOffset, long rngSeed) {
            this.timeSeriesRandomOffset = timeSeriesRandomOffset;
            this.timeSeriesRandomOffsetSeed = rngSeed;
            return this;
        }

        public RecordReaderMultiDataSetIterator build() {
            if (this.recordReaders.isEmpty() && this.sequenceRecordReaders.isEmpty()) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with no readers");
            }
            if (this.batchSize <= 0) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with batch size <= 0");
            }
            if (this.inputs.isEmpty() && this.outputs.isEmpty()) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with no inputs/outputs");
            }
            for (SubsetDetails ssd : this.inputs) {
                if (this.recordReaders.containsKey(ssd.readerName) || this.sequenceRecordReaders.containsKey(ssd.readerName)) continue;
                throw new IllegalStateException("Invalid input name: \"" + ssd.readerName + "\" - no reader found with this name");
            }
            for (SubsetDetails ssd : this.outputs) {
                if (this.recordReaders.containsKey(ssd.readerName) || this.sequenceRecordReaders.containsKey(ssd.readerName)) continue;
                throw new IllegalStateException("Invalid output name: \"" + ssd.readerName + "\" - no reader found with this name");
            }
            return new RecordReaderMultiDataSetIterator(this);
        }
    }

    public static enum AlignmentMode {
        EQUAL_LENGTH,
        ALIGN_START,
        ALIGN_END;

    }
}

