/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.base;

import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.datasets.base.MnistFetcher;
import org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmnistFetcher
extends MnistFetcher {
    private static final Logger log = LoggerFactory.getLogger(EmnistFetcher.class);
    private final EmnistDataSetIterator.Set ds;

    public EmnistFetcher(EmnistDataSetIterator.Set ds) {
        this.ds = ds;
    }

    private static String getImagesFileName(EmnistDataSetIterator.Set ds, boolean train) {
        return "emnist-" + EmnistFetcher.name(ds) + "-" + (train ? "train" : "test") + "-images-idx3-ubyte.gz";
    }

    private static String getImagesFileNameUnzipped(EmnistDataSetIterator.Set ds, boolean train) {
        return "emnist-" + EmnistFetcher.name(ds) + "-" + (train ? "train" : "test") + "-images-idx3-ubyte";
    }

    private static String getLabelsFileName(EmnistDataSetIterator.Set ds, boolean train) {
        return "emnist-" + EmnistFetcher.name(ds) + "-" + (train ? "train" : "test") + "-labels-idx1-ubyte.gz";
    }

    private static String getLabelsFileNameUnzipped(EmnistDataSetIterator.Set ds, boolean train) {
        return "emnist-" + EmnistFetcher.name(ds) + "-" + (train ? "train" : "test") + "-labels-idx1-ubyte";
    }

    private static String getMappingFileName(EmnistDataSetIterator.Set ds, boolean train) {
        return "emnist-" + EmnistFetcher.name(ds) + "-mapping.txt";
    }

    private static String name(EmnistDataSetIterator.Set ds) {
        switch (ds) {
            case COMPLETE: {
                return "byclass";
            }
            case MERGE: {
                return "bymerge";
            }
            case BALANCED: {
                return "balanced";
            }
            case LETTERS: {
                return "letters";
            }
            case DIGITS: {
                return "digits";
            }
            case MNIST: {
                return "mnist";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }

    @Override
    public String getName() {
        return "EMNIST";
    }

    @Override
    public String getTrainingFilesURL() {
        return DL4JResources.getURLString((String)("datasets/emnist/" + EmnistFetcher.getImagesFileName(this.ds, true)));
    }

    @Override
    public String getTrainingFilesMD5() {
        switch (this.ds) {
            case COMPLETE: {
                return "712dda0bd6f00690f32236ae4325c377";
            }
            case MERGE: {
                return "4a792d4df261d7e1ba27979573bf53f3";
            }
            case BALANCED: {
                return "4041b0d6f15785d3fa35263901b5496b";
            }
            case LETTERS: {
                return "8795078f199c478165fe18db82625747";
            }
            case DIGITS: {
                return "d2662ecdc47895a6bbfce25de9e9a677";
            }
            case MNIST: {
                return "3663598a39195d030895b6304abb5065";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)this.ds));
    }

    @Override
    public String getTrainingFilesFilename() {
        return EmnistFetcher.getImagesFileName(this.ds, true);
    }

    @Override
    public String getTrainingFilesFilename_unzipped() {
        return EmnistFetcher.getImagesFileNameUnzipped(this.ds, true);
    }

    @Override
    public String getTrainingFileLabelsURL() {
        return DL4JResources.getURLString((String)("datasets/emnist/" + EmnistFetcher.getLabelsFileName(this.ds, true)));
    }

    @Override
    public String getTrainingFileLabelsMD5() {
        switch (this.ds) {
            case COMPLETE: {
                return "ee299a3ee5faf5c31e9406763eae7e43";
            }
            case MERGE: {
                return "491be69ef99e1ab1f5b7f9ccc908bb26";
            }
            case BALANCED: {
                return "7a35cc7b2b7ee7671eddf028570fbd20";
            }
            case LETTERS: {
                return "c16de4f1848ddcdddd39ab65d2a7be52";
            }
            case DIGITS: {
                return "2223fcfee618ac9c89ef20b6e48bcf9e";
            }
            case MNIST: {
                return "6c092f03c9bb63e678f80f8bc605fe37";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)this.ds));
    }

    @Override
    public String getTrainingFileLabelsFilename() {
        return EmnistFetcher.getLabelsFileName(this.ds, true);
    }

    @Override
    public String getTrainingFileLabelsFilename_unzipped() {
        return EmnistFetcher.getLabelsFileNameUnzipped(this.ds, true);
    }

    @Override
    public String getTestFilesURL() {
        return DL4JResources.getURLString((String)("datasets/emnist/" + EmnistFetcher.getImagesFileName(this.ds, false)));
    }

    @Override
    public String getTestFilesMD5() {
        switch (this.ds) {
            case COMPLETE: {
                return "1435209e34070a9002867a9ab50160d7";
            }
            case MERGE: {
                return "8eb5d34c91f1759a55831c37ec2a283f";
            }
            case BALANCED: {
                return "6818d20fe2ce1880476f747bbc80b22b";
            }
            case LETTERS: {
                return "382093a19703f68edac6d01b8dfdfcad";
            }
            case DIGITS: {
                return "a159b8b3bd6ab4ed4793c1cb71a2f5cc";
            }
            case MNIST: {
                return "fb51b6430fc4dd67deaada1bf25d4524";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)this.ds));
    }

    @Override
    public String getTestFilesFilename() {
        return EmnistFetcher.getImagesFileName(this.ds, false);
    }

    @Override
    public String getTestFilesFilename_unzipped() {
        return EmnistFetcher.getImagesFileNameUnzipped(this.ds, false);
    }

    @Override
    public String getTestFileLabelsURL() {
        return DL4JResources.getURLString((String)("datasets/emnist/" + EmnistFetcher.getLabelsFileName(this.ds, false)));
    }

    @Override
    public String getTestFileLabelsMD5() {
        switch (this.ds) {
            case COMPLETE: {
                return "7a0f934bd176c798ecba96b36fda6657";
            }
            case MERGE: {
                return "c13f4cd5211cdba1b8fa992dae2be992";
            }
            case BALANCED: {
                return "acd3694070dcbf620e36670519d4b32f";
            }
            case LETTERS: {
                return "d4108920cd86601ec7689a97f2de7f59";
            }
            case DIGITS: {
                return "8afde66ea51d865689083ba6bb779fac";
            }
            case MNIST: {
                return "ae7f6be798a9a5d5f2bd32e078a402dd";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)this.ds));
    }

    @Override
    public String getTestFileLabelsFilename() {
        return EmnistFetcher.getLabelsFileName(this.ds, false);
    }

    @Override
    public String getTestFileLabelsFilename_unzipped() {
        return EmnistFetcher.getLabelsFileNameUnzipped(this.ds, false);
    }

    public static int numLabels(EmnistDataSetIterator.Set dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return 62;
            }
            case MERGE: {
                return 47;
            }
            case BALANCED: {
                return 47;
            }
            case LETTERS: {
                return 26;
            }
            case DIGITS: {
                return 10;
            }
            case MNIST: {
                return 10;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }
}

