/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.util.Random;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.io.filters.RandomPathFilter;
import org.datavec.api.io.labels.ParentPathLabelGenerator;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.recordreader.ImageRecordReader;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.datasets.fetchers.CacheableExtractableDataSetFetcher;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.nd4j.base.Preconditions;

public class TinyImageNetFetcher
extends CacheableExtractableDataSetFetcher {
    public static final String WORDS_FILENAME = "words.txt";
    public static final String LOCAL_CACHE_NAME = "TINYIMAGENET_200";
    public static int INPUT_WIDTH = 64;
    public static int INPUT_HEIGHT = 64;
    public static int INPUT_CHANNELS = 3;
    public static int NUM_LABELS = 200;
    public static int NUM_EXAMPLES = NUM_LABELS * 500;

    @Override
    public String remoteDataUrl(DataSetType set) {
        return DL4JResources.getURLString((String)"datasets/tinyimagenet_200_dl4j.v1.zip");
    }

    @Override
    public String localCacheName() {
        return LOCAL_CACHE_NAME;
    }

    @Override
    public long expectedChecksum(DataSetType set) {
        return 33822361L;
    }

    @Override
    public RecordReader getRecordReader(long rngSeed, int[] imgDim, DataSetType set, ImageTransform imageTransform) {
        File datasetPath;
        Preconditions.checkState((imgDim == null || imgDim.length == 2 ? 1 : 0) != 0, (String)"Invalid image dimensions: must be null or lenth 2. Got: %s", (Object)imgDim);
        File localCache = this.getLocalCacheDir();
        TinyImageNetFetcher.deleteIfEmpty(localCache);
        try {
            if (!localCache.exists()) {
                this.downloadAndExtract();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not download TinyImageNet", e);
        }
        Random rng = new Random(rngSeed);
        switch (set) {
            case TRAIN: {
                datasetPath = new File(localCache, "/train/");
                break;
            }
            case TEST: {
                datasetPath = new File(localCache, "/test/");
                break;
            }
            case VALIDATION: {
                throw new IllegalArgumentException("You will need to manually iterate the /validation/images/ directory, TinyImageNet does not provide labels");
            }
            default: {
                datasetPath = new File(localCache, "/train/");
            }
        }
        RandomPathFilter pathFilter = new RandomPathFilter(rng, BaseImageLoader.ALLOWED_FORMATS);
        FileSplit filesInDir = new FileSplit(datasetPath, BaseImageLoader.ALLOWED_FORMATS, rng);
        InputSplit[] filesInDirSplit = filesInDir.sample((PathFilter)pathFilter, new double[]{1.0});
        int h = imgDim == null ? INPUT_HEIGHT : imgDim[0];
        int w = imgDim == null ? INPUT_WIDTH : imgDim[1];
        ImageRecordReader rr = new ImageRecordReader((long)h, (long)w, (long)INPUT_CHANNELS, (PathLabelGenerator)new ParentPathLabelGenerator(), imageTransform);
        try {
            rr.initialize(filesInDirSplit[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rr;
    }
}

