/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    protected static final Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    protected File BASE_DIR = new File(System.getProperty("user.home"));
    protected static final String LOCAL_DIR_NAME = "MNIST";
    protected File FILE_DIR = new File(this.BASE_DIR, "MNIST");
    private File fileDir;
    private static final String trainingFilesURL = "http://benchmark.deeplearn.online/mnist/train-images-idx3-ubyte.gz";
    private static final String trainingFilesMD5 = "f68b3c2dcbeaaa9fbdd348bbdeb94873";
    private static final String trainingFilesFilename = "train-images-idx3-ubyte.gz";
    public static final String trainingFilesFilename_unzipped = "train-images-idx3-ubyte";
    private static final String trainingFileLabelsURL = "http://benchmark.deeplearn.online/mnist/train-labels-idx1-ubyte.gz";
    private static final String trainingFileLabelsMD5 = "d53e105ee54ea40749a09fcbcd1e9432";
    private static final String trainingFileLabelsFilename = "train-labels-idx1-ubyte.gz";
    public static final String trainingFileLabelsFilename_unzipped = "train-labels-idx1-ubyte";
    private static final String testFilesURL = "http://benchmark.deeplearn.online/mnist/t10k-images-idx3-ubyte.gz";
    private static final String testFilesMD5 = "9fb629c4189551a2d022fa330f9573f3";
    private static final String testFilesFilename = "t10k-images-idx3-ubyte.gz";
    public static final String testFilesFilename_unzipped = "t10k-images-idx3-ubyte";
    private static final String testFileLabelsURL = "http://benchmark.deeplearn.online/mnist/t10k-labels-idx1-ubyte.gz";
    private static final String testFileLabelsMD5 = "ec29112dd5afa0611ce80d1b7f02629c";
    private static final String testFileLabelsFilename = "t10k-labels-idx1-ubyte.gz";
    public static final String testFileLabelsFilename_unzipped = "t10k-labels-idx1-ubyte";

    public String getName() {
        return LOCAL_DIR_NAME;
    }

    public File getBaseDir() {
        return this.FILE_DIR;
    }

    public String getTrainingFilesURL() {
        return trainingFilesURL;
    }

    public String getTrainingFilesMD5() {
        return trainingFilesMD5;
    }

    public String getTrainingFilesFilename() {
        return trainingFilesFilename;
    }

    public String getTrainingFilesFilename_unzipped() {
        return trainingFilesFilename_unzipped;
    }

    public String getTrainingFileLabelsURL() {
        return trainingFileLabelsURL;
    }

    public String getTrainingFileLabelsMD5() {
        return trainingFileLabelsMD5;
    }

    public String getTrainingFileLabelsFilename() {
        return trainingFileLabelsFilename;
    }

    public String getTrainingFileLabelsFilename_unzipped() {
        return trainingFileLabelsFilename_unzipped;
    }

    public String getTestFilesURL() {
        return testFilesURL;
    }

    public String getTestFilesMD5() {
        return testFilesMD5;
    }

    public String getTestFilesFilename() {
        return testFilesFilename;
    }

    public String getTestFilesFilename_unzipped() {
        return testFilesFilename_unzipped;
    }

    public String getTestFileLabelsURL() {
        return testFileLabelsURL;
    }

    public String getTestFileLabelsMD5() {
        return testFileLabelsMD5;
    }

    public String getTestFileLabelsFilename() {
        return testFileLabelsFilename;
    }

    public String getTestFileLabelsFilename_unzipped() {
        return testFileLabelsFilename_unzipped;
    }

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File baseDir = this.getBaseDir();
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading {}...", (Object)this.getName());
        File tarFile = new File(baseDir, this.getTrainingFilesFilename());
        File testFileLabels = new File(baseDir, this.getTestFilesFilename());
        this.tryDownloadingAFewTimes(new URL(this.getTrainingFilesURL()), tarFile, this.getTrainingFilesMD5());
        this.tryDownloadingAFewTimes(new URL(this.getTestFilesURL()), testFileLabels, this.getTestFilesMD5());
        ArchiveUtils.unzipFileTo((String)tarFile.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        ArchiveUtils.unzipFileTo((String)testFileLabels.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        File labels = new File(baseDir, this.getTrainingFileLabelsFilename());
        File labelsTest = new File(baseDir, this.getTestFileLabelsFilename());
        this.tryDownloadingAFewTimes(new URL(this.getTrainingFileLabelsURL()), labels, this.getTrainingFileLabelsMD5());
        this.tryDownloadingAFewTimes(new URL(this.getTestFileLabelsURL()), labelsTest, this.getTestFileLabelsMD5());
        ArchiveUtils.unzipFileTo((String)labels.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        ArchiveUtils.unzipFileTo((String)labelsTest.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        this.fileDir = baseDir;
        return this.fileDir;
    }

    private void tryDownloadingAFewTimes(URL url, File f, String targetMD5) throws IOException {
        this.tryDownloadingAFewTimes(0, url, f, targetMD5);
    }

    private void tryDownloadingAFewTimes(int attempt, URL url, File f, String targetMD5) throws IOException {
        int maxTries = 3;
        boolean isCorrectFile = f.isFile();
        if (attempt < maxTries && !isCorrectFile) {
            FileUtils.copyURLToFile((URL)url, (File)f);
            if (!this.checkMD5OfFile(targetMD5, f)) {
                f.delete();
                this.tryDownloadingAFewTimes(attempt + 1, url, f, targetMD5);
            }
        } else if (!isCorrectFile) {
            throw new IOException("Could not download " + url.getPath() + "\n properly despite trying " + maxTries + " times, check your connection. File info:\nTarget MD5: " + targetMD5 + "\nHash matches: " + this.checkMD5OfFile(targetMD5, f) + "\nIs valid file: " + f.isFile());
        }
    }

    private boolean checkMD5OfFile(String targetMD5, File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)file);
        String trueMd5 = DigestUtils.md5Hex((InputStream)in);
        IOUtils.closeQuietly((InputStream)in);
        return targetMD5.equals(trueMd5);
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public File getBASE_DIR() {
        return this.BASE_DIR;
    }

    public File getFILE_DIR() {
        return this.FILE_DIR;
    }

    public File getFileDir() {
        return this.fileDir;
    }

    public void setBASE_DIR(File BASE_DIR) {
        this.BASE_DIR = BASE_DIR;
    }

    public void setFILE_DIR(File FILE_DIR) {
        this.FILE_DIR = FILE_DIR;
    }

    public void setFileDir(File fileDir) {
        this.fileDir = fileDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MnistFetcher)) {
            return false;
        }
        MnistFetcher other = (MnistFetcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$BASE_DIR = this.getBASE_DIR();
        File other$BASE_DIR = other.getBASE_DIR();
        if (this$BASE_DIR == null ? other$BASE_DIR != null : !((Object)this$BASE_DIR).equals(other$BASE_DIR)) {
            return false;
        }
        File this$FILE_DIR = this.getFILE_DIR();
        File other$FILE_DIR = other.getFILE_DIR();
        if (this$FILE_DIR == null ? other$FILE_DIR != null : !((Object)this$FILE_DIR).equals(other$FILE_DIR)) {
            return false;
        }
        File this$fileDir = this.getFileDir();
        File other$fileDir = other.getFileDir();
        return !(this$fileDir == null ? other$fileDir != null : !((Object)this$fileDir).equals(other$fileDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MnistFetcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $BASE_DIR = this.getBASE_DIR();
        result = result * 59 + ($BASE_DIR == null ? 43 : ((Object)$BASE_DIR).hashCode());
        File $FILE_DIR = this.getFILE_DIR();
        result = result * 59 + ($FILE_DIR == null ? 43 : ((Object)$FILE_DIR).hashCode());
        File $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 43 : ((Object)$fileDir).hashCode());
        return result;
    }

    public String toString() {
        return "MnistFetcher(BASE_DIR=" + this.getBASE_DIR() + ", FILE_DIR=" + this.getFILE_DIR() + ", fileDir=" + this.getFileDir() + ")";
    }
}

