/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.api.storage.impl;

import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.DatatypeConverter;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.api.storage.StorageType;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUIStatsStorageRouter
implements StatsStorageRouter {
    private static final Logger log = LoggerFactory.getLogger(RemoteUIStatsStorageRouter.class);
    public static final String DEFAULT_PATH = "remoteReceive";
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final long DEFAULT_BASE_RETR_DELAY_MS = 1000L;
    public static final double DEFAULT_RETRY_BACKOFF_FACTOR = 2.0;
    private static final long MAX_SHUTDOWN_WARN_COUNT = 5L;
    private final String USER_AGENT = "Mozilla/5.0";
    private URL url;
    private int maxRetryCount;
    private long retryDelayMS;
    private double retryBackoffFactor;
    private LinkedBlockingDeque<ToPost> queue = new LinkedBlockingDeque();
    private Thread postThread;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private AtomicLong shutdownWarnCount = new AtomicLong(0L);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public RemoteUIStatsStorageRouter(String address) {
        this(address, 10, 1000L, 2.0);
    }

    public RemoteUIStatsStorageRouter(String address, int maxRetryCount, long retryDelayMS, double retryBackoffFactor) {
        this(address, DEFAULT_PATH, maxRetryCount, retryDelayMS, retryBackoffFactor);
    }

    public RemoteUIStatsStorageRouter(String address, String path, int maxRetryCount, long retryDelayMS, double retryBackoffFactor) {
        this.maxRetryCount = maxRetryCount;
        this.retryDelayMS = retryDelayMS;
        this.retryBackoffFactor = retryBackoffFactor;
        String url = address;
        if (path != null) {
            url = url.endsWith("/") ? url + path : url + "/" + path;
        }
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.postThread = new Thread(new PostRunnable());
        this.postThread.setDaemon(true);
        this.postThread.start();
    }

    @Override
    public void putStorageMetaData(StorageMetaData storageMetaData) {
        this.putStorageMetaData(Collections.singleton(storageMetaData));
    }

    @Override
    public void putStorageMetaData(Collection<? extends StorageMetaData> storageMetaData) {
        if (this.shutdown.get()) {
            long count = this.shutdownWarnCount.getAndIncrement();
            if (count <= 5L) {
                log.warn("Info posted to RemoteUIStatsStorageRouter but router is shut down.");
            }
            if (count == 5L) {
                log.warn("RemoteUIStatsStorageRouter: Reached max shutdown warnings. No further warnings will be produced.");
            }
        } else {
            for (StorageMetaData storageMetaData2 : storageMetaData) {
                this.queue.add(new ToPost(storageMetaData2, null, null));
            }
        }
    }

    @Override
    public void putStaticInfo(Persistable staticInfo) {
        this.putStaticInfo(Collections.singletonList(staticInfo));
    }

    @Override
    public void putStaticInfo(Collection<? extends Persistable> staticInfo) {
        if (this.shutdown.get()) {
            long count = this.shutdownWarnCount.getAndIncrement();
            if (count <= 5L) {
                log.warn("Info posted to RemoteUIStatsStorageRouter but router is shut down.");
            }
            if (count == 5L) {
                log.warn("RemoteUIStatsStorageRouter: Reached max shutdown warnings. No further warnings will be produced.");
            }
        } else {
            for (Persistable persistable : staticInfo) {
                this.queue.add(new ToPost(null, persistable, null));
            }
        }
    }

    @Override
    public void putUpdate(Persistable update) {
        this.putUpdate(Collections.singleton(update));
    }

    @Override
    public void putUpdate(Collection<? extends Persistable> updates) {
        if (this.shutdown.get()) {
            long count = this.shutdownWarnCount.getAndIncrement();
            if (count <= 5L) {
                log.warn("Info posted to RemoteUIStatsStorageRouter but router is shut down.");
            }
            if (count == 5L) {
                log.warn("RemoteUIStatsStorageRouter: Reached max shutdown warnings. No further warnings will be produced.");
            }
        } else {
            for (Persistable persistable : updates) {
                this.queue.add(new ToPost(null, null, persistable));
            }
        }
    }

    private HttpURLConnection getConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        return connection;
    }

    private boolean tryPost(ToPost toPost) throws IOException {
        String str;
        Persistable p;
        StorageType type;
        byte[] asBytes;
        String className;
        HttpURLConnection connection = this.getConnection();
        if (toPost.getMeta() != null) {
            StorageMetaData smd = toPost.getMeta();
            className = smd.getClass().getName();
            asBytes = smd.encode();
            type = StorageType.MetaData;
        } else if (toPost.getStaticInfo() != null) {
            p = toPost.getStaticInfo();
            className = p.getClass().getName();
            asBytes = p.encode();
            type = StorageType.StaticInfo;
        } else {
            p = toPost.getUpdate();
            className = p.getClass().getName();
            asBytes = p.encode();
            type = StorageType.Update;
        }
        String base64 = DatatypeConverter.printBase64Binary((byte[])asBytes);
        LinkedHashMap<String, String> jsonObj = new LinkedHashMap<String, String>();
        jsonObj.put("type", type.name());
        jsonObj.put("class", className);
        jsonObj.put("data", base64);
        try {
            str = objectMapper.writeValueAsString(jsonObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
        dos.writeBytes(str);
        dos.flush();
        dos.close();
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                log.warn("Error posting to remote UI - received response code {}\tContent: {}", (Object)response, (Object)response.toString());
                return false;
            }
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg.contains("403 for URL")) {
                log.warn("Error posting to remote UI at {} (Response code: 403). Remote listener support is not enabled? use UIServer.getInstance().enableRemoteListener()", (Object)this.url, (Object)e);
            } else {
                log.warn("Error posting to remote UI at {}", (Object)this.url, (Object)e);
            }
            return false;
        }
        return true;
    }

    private class PostRunnable
    implements Runnable {
        private int failureCount = 0;
        private long nextDelayMs = RemoteUIStatsStorageRouter.access$100(RemoteUIStatsStorageRouter.this);

        private PostRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runHelper();
            }
            catch (Exception e) {
                log.error("Exception encountered in remote UI posting thread. Shutting down.", (Throwable)e);
                RemoteUIStatsStorageRouter.this.shutdown.set(true);
            }
        }

        private void runHelper() {
            block4: while (!RemoteUIStatsStorageRouter.this.shutdown.get()) {
                ToPost t;
                ArrayList<ToPost> list = new ArrayList<ToPost>();
                try {
                    t = (ToPost)RemoteUIStatsStorageRouter.this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                list.add(t);
                RemoteUIStatsStorageRouter.this.queue.drainTo(list);
                int successCount = 0;
                for (ToPost toPost : list) {
                    boolean success;
                    try {
                        success = RemoteUIStatsStorageRouter.this.tryPost(toPost);
                    }
                    catch (IOException e) {
                        ++this.failureCount;
                        log.warn("Error posting to remote UI at {}, consecutive failure count = {}. Waiting {} ms before retrying", new Object[]{RemoteUIStatsStorageRouter.this.url, this.failureCount, this.nextDelayMs, e});
                        success = false;
                    }
                    if (!success) {
                        for (int i = list.size() - 1; i > successCount; --i) {
                            RemoteUIStatsStorageRouter.this.queue.addFirst(list.get(i));
                        }
                        this.waitForRetry();
                        continue block4;
                    }
                    ++successCount;
                    this.failureCount = 0;
                    this.nextDelayMs = RemoteUIStatsStorageRouter.this.retryDelayMS;
                }
            }
        }

        private void waitForRetry() {
            if (RemoteUIStatsStorageRouter.this.maxRetryCount >= 0 && this.failureCount > RemoteUIStatsStorageRouter.this.maxRetryCount) {
                throw new RuntimeException("RemoteUIStatsStorageRouter: hit maximum consecutive failures(" + RemoteUIStatsStorageRouter.this.maxRetryCount + "). Shutting down remote router thread");
            }
            try {
                Thread.sleep(this.nextDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextDelayMs = (long)((double)this.nextDelayMs * RemoteUIStatsStorageRouter.this.retryBackoffFactor);
        }
    }

    private static class ToPost {
        private final StorageMetaData meta;
        private final Persistable staticInfo;
        private final Persistable update;

        @ConstructorProperties(value={"meta", "staticInfo", "update"})
        public ToPost(StorageMetaData meta, Persistable staticInfo, Persistable update) {
            this.meta = meta;
            this.staticInfo = staticInfo;
            this.update = update;
        }

        public StorageMetaData getMeta() {
            return this.meta;
        }

        public Persistable getStaticInfo() {
            return this.staticInfo;
        }

        public Persistable getUpdate() {
            return this.update;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToPost)) {
                return false;
            }
            ToPost other = (ToPost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StorageMetaData this$meta = this.getMeta();
            StorageMetaData other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
                return false;
            }
            Persistable this$staticInfo = this.getStaticInfo();
            Persistable other$staticInfo = other.getStaticInfo();
            if (this$staticInfo == null ? other$staticInfo != null : !this$staticInfo.equals(other$staticInfo)) {
                return false;
            }
            Persistable this$update = this.getUpdate();
            Persistable other$update = other.getUpdate();
            return !(this$update == null ? other$update != null : !this$update.equals(other$update));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ToPost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StorageMetaData $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
            Persistable $staticInfo = this.getStaticInfo();
            result = result * 59 + ($staticInfo == null ? 43 : $staticInfo.hashCode());
            Persistable $update = this.getUpdate();
            result = result * 59 + ($update == null ? 43 : $update.hashCode());
            return result;
        }

        public String toString() {
            return "RemoteUIStatsStorageRouter.ToPost(meta=" + this.getMeta() + ", staticInfo=" + this.getStaticInfo() + ", update=" + this.getUpdate() + ")";
        }
    }
}

