/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.sptree;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.impl.accum.distances.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance;
import org.nd4j.linalg.factory.Nd4j;

public class DataPoint
implements Serializable {
    private int index;
    private INDArray point;
    private int d;
    private String functionName;
    private boolean invert = false;

    public DataPoint(int index, INDArray point, boolean invert) {
        this(index, point, "euclidean");
        this.invert = invert;
    }

    public DataPoint(int index, INDArray point, String functionName, boolean invert) {
        this.index = index;
        this.point = point;
        this.functionName = functionName;
        this.d = point.length();
        this.invert = invert;
    }

    public DataPoint(int index, INDArray point) {
        this(index, point, false);
    }

    public DataPoint(int index, INDArray point, String functionName) {
        this(index, point, functionName, false);
    }

    public double distance(DataPoint point) {
        switch (this.functionName) {
            case "euclidean": {
                double ret = Nd4j.getExecutioner().execAndReturn((Accumulation)new EuclideanDistance(this.point, point.point)).getFinalResult().doubleValue();
                return this.invert ? -ret : ret;
            }
            case "cosinesimilarity": {
                double ret2 = Nd4j.getExecutioner().execAndReturn((Accumulation)new CosineSimilarity(this.point, point.point)).getFinalResult().doubleValue();
                return this.invert ? -ret2 : ret2;
            }
            case "manhattan": {
                double ret3 = Nd4j.getExecutioner().execAndReturn((Accumulation)new ManhattanDistance(this.point, point.point)).getFinalResult().doubleValue();
                return this.invert ? -ret3 : ret3;
            }
            case "dot": {
                double dotRet = Nd4j.getBlasWrapper().dot(this.point, point.point);
                return this.invert ? -dotRet : dotRet;
            }
        }
        double ret4 = Nd4j.getExecutioner().execAndReturn((Accumulation)new EuclideanDistance(this.point, point.point)).getFinalResult().doubleValue();
        return this.invert ? -ret4 : ret4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)o;
        if (this.index != dataPoint.index) {
            return false;
        }
        return !(this.point == null ? dataPoint.point != null : !this.point.equals(dataPoint.point));
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + (this.point != null ? this.point.hashCode() : 0);
        return result;
    }

    public int getD() {
        return this.d;
    }

    public void setD(int d) {
        this.d = d;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public INDArray getPoint() {
        return this.point;
    }

    public void setPoint(INDArray point) {
        this.point = point;
    }
}

