/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class SamplingDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -2700563801361726914L;
    private DataSet sampleFrom;
    private int batchSize;
    private int totalNumberSamples;
    private int numTimesSampled;
    private DataSetPreProcessor preProcessor;

    public SamplingDataSetIterator(DataSet sampleFrom, int batchSize, int totalNumberSamples) {
        this.sampleFrom = sampleFrom;
        this.batchSize = batchSize;
        this.totalNumberSamples = totalNumberSamples;
    }

    public boolean hasNext() {
        return this.numTimesSampled < this.totalNumberSamples;
    }

    public DataSet next() {
        DataSet ret = this.sampleFrom.sample(this.batchSize);
        this.numTimesSampled += this.batchSize;
        return ret;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalExamples() {
        return this.totalNumberSamples * this.batchSize;
    }

    public int inputColumns() {
        return this.sampleFrom.numInputs();
    }

    public int totalOutcomes() {
        return this.sampleFrom.numOutcomes();
    }

    public boolean resetSupported() {
        return true;
    }

    public void reset() {
        this.numTimesSampled = 0;
    }

    public int batch() {
        return this.batchSize;
    }

    public int cursor() {
        return this.numTimesSampled;
    }

    public int numExamples() {
        return this.sampleFrom.numExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public DataSet next(int num) {
        DataSet ret = this.sampleFrom.sample(num);
        ++this.numTimesSampled;
        return ret;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

