/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.deeplearning4j.berkeley.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;

public abstract class AbstractDataSetIterator<T>
implements DataSetIterator {
    private DataSetPreProcessor preProcessor;
    private transient Iterable<Pair<T, T>> iterable;
    private transient Iterator<Pair<T, T>> iterator;
    private final int batchSize;
    private final Queue<org.nd4j.linalg.dataset.DataSet> queue = new LinkedBlockingQueue<org.nd4j.linalg.dataset.DataSet>(1);
    private List<String> labels;
    private int numFeatures = -1;
    private int numLabels = -1;

    protected AbstractDataSetIterator(@NonNull Iterable<Pair<T, T>> iterable, int batchSize) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (batchSize < 1) {
            throw new IllegalStateException("batchSize can't be < 1");
        }
        this.iterable = iterable;
        this.iterator = this.iterable.iterator();
        this.batchSize = batchSize;
        this.fillQueue();
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        throw new IllegalStateException("next(int) isn't supported for this DataSetIterator");
    }

    public int totalExamples() {
        return 0;
    }

    public int inputColumns() {
        return this.numFeatures;
    }

    public int totalOutcomes() {
        return this.numLabels;
    }

    public boolean resetSupported() {
        return this.iterable != null;
    }

    public void reset() {
        this.queue.clear();
        if (this.iterable != null) {
            this.iterator = this.iterable.iterator();
        }
    }

    public int batch() {
        return this.batchSize;
    }

    public int cursor() {
        return 0;
    }

    public int numExamples() {
        return this.totalExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasNext() {
        this.fillQueue();
        return !this.queue.isEmpty();
    }

    protected void fillQueue() {
        if (this.queue.isEmpty()) {
            INDArray labels = null;
            INDArray features = null;
            ArrayList<INDArray> cLabels = new ArrayList<INDArray>();
            ArrayList<INDArray> cFeatures = new ArrayList<INDArray>();
            for (int cnt = 0; cnt < this.batchSize && this.iterator.hasNext(); ++cnt) {
                Pair<T, T> pair = this.iterator.next();
                if (this.numFeatures < 1) {
                    if (pair.getFirst() instanceof INDArray) {
                        this.numFeatures = ((INDArray)pair.getFirst()).length();
                        this.numLabels = ((INDArray)pair.getSecond()).length();
                    } else if (pair.getFirst() instanceof float[]) {
                        this.numFeatures = ((float[])pair.getFirst()).length;
                        this.numLabels = ((float[])pair.getSecond()).length;
                    } else if (pair.getFirst() instanceof double[]) {
                        this.numFeatures = ((double[])pair.getFirst()).length;
                        this.numLabels = ((double[])pair.getSecond()).length;
                    }
                }
                if (pair.getFirst() instanceof INDArray) {
                    cFeatures.add((INDArray)pair.getFirst());
                    cLabels.add((INDArray)pair.getSecond());
                    continue;
                }
                if (pair.getFirst() instanceof float[]) {
                    cFeatures.add(Nd4j.create((float[])((float[])pair.getFirst())));
                    cLabels.add(Nd4j.create((float[])((float[])pair.getSecond())));
                    continue;
                }
                if (!(pair.getFirst() instanceof double[])) continue;
                cFeatures.add(Nd4j.create((double[])((double[])pair.getFirst())));
                cLabels.add(Nd4j.create((double[])((double[])pair.getSecond())));
            }
            if (cFeatures.size() == this.batchSize) {
                features = Nd4j.vstack(cFeatures);
                labels = Nd4j.vstack(cLabels);
                org.nd4j.linalg.dataset.DataSet dataSet = new org.nd4j.linalg.dataset.DataSet(features, labels);
                this.queue.add(dataSet);
            }
        }
    }

    public org.nd4j.linalg.dataset.DataSet next() throws NoSuchElementException {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        org.nd4j.linalg.dataset.DataSet dataSet = this.queue.poll();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)dataSet);
        }
        return dataSet;
    }

    public void remove() {
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

