/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.canova.image.loader.ImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ImageRender {
    private ImageRender() {
    }

    public static void render(INDArray image, String path) throws IOException {
        BufferedImage imageToRender = null;
        if (image.rank() == 3) {
            ImageLoader loader = new ImageLoader(image.size(-1), image.size(-2), image.size(-3));
            imageToRender = new BufferedImage(image.size(-1), image.size(-2), 5);
            loader.toBufferedImageRGB(image, imageToRender);
        } else if (image.rank() == 2) {
            imageToRender = new BufferedImage(image.size(-1), image.size(-2), 10);
            for (int i = 0; i < image.length(); ++i) {
                imageToRender.getRaster().setSample(i % image.size(-1), i / image.size(-2), 0, (int)(255.0 * image.getDouble(i)));
            }
        }
        ImageIO.write(imageToRender, "png", new File(path));
    }
}

