/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph.rnn;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LastTimeStepVertex
extends GraphVertex {
    private String maskArrayInputName;

    public LastTimeStepVertex(@JsonProperty(value="maskArrayInputName") String maskArrayInputName) {
        this.maskArrayInputName = maskArrayInputName;
    }

    @Override
    public GraphVertex clone() {
        return new LastTimeStepVertex(this.maskArrayInputName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LastTimeStepVertex)) {
            return false;
        }
        LastTimeStepVertex ltsv = (LastTimeStepVertex)o;
        if (this.maskArrayInputName == null && ltsv.maskArrayInputName != null || this.maskArrayInputName != null && ltsv.maskArrayInputName == null) {
            return false;
        }
        return this.maskArrayInputName == null || this.maskArrayInputName.equals(ltsv.maskArrayInputName);
    }

    @Override
    public int hashCode() {
        return this.maskArrayInputName == null ? 452766971 : this.maskArrayInputName.hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.impl.rnn.LastTimeStepVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.rnn.LastTimeStepVertex(graph, name, idx, this.maskArrayInputName);
    }

    @Override
    public InputType getOutputType(InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("Invalid input type: cannot get last time step of more than 1 input");
        }
        if (vertexInputs[0].getType() != InputType.Type.RNN) {
            throw new InvalidInputTypeException("Invalid input type: cannot get subset of non RNN input (got: " + vertexInputs[0] + ")");
        }
        return InputType.feedForward(((InputType.InputTypeRecurrent)vertexInputs[0]).getSize());
    }

    public String toString() {
        return "LastTimeStepVertex(inputName=" + this.maskArrayInputName + ")";
    }

    public String getMaskArrayInputName() {
        return this.maskArrayInputName;
    }

    public void setMaskArrayInputName(String maskArrayInputName) {
        this.maskArrayInputName = maskArrayInputName;
    }
}

