/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class IteratorDataSetIterator
implements DataSetIterator {
    private final Iterator<org.nd4j.linalg.dataset.DataSet> iterator;
    private final int batchSize;
    private final LinkedList<org.nd4j.linalg.dataset.DataSet> queued;
    private DataSetPreProcessor preProcessor;
    private int inputColumns = -1;
    private int totalOutcomes = -1;
    private int cursor = 0;

    public IteratorDataSetIterator(Iterator<org.nd4j.linalg.dataset.DataSet> iterator, int batchSize) {
        this.iterator = iterator;
        this.batchSize = batchSize;
        this.queued = new LinkedList();
    }

    public boolean hasNext() {
        return !this.queued.isEmpty() || this.iterator.hasNext();
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        return this.next(this.batchSize);
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        int nExamples;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<org.nd4j.linalg.dataset.DataSet> list = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        for (int countSoFar = 0; (!this.queued.isEmpty() || this.iterator.hasNext()) && countSoFar < this.batchSize; countSoFar += nExamples) {
            org.nd4j.linalg.dataset.DataSet next = !this.queued.isEmpty() ? this.queued.removeFirst() : this.iterator.next();
            nExamples = next.numExamples();
            if (countSoFar + nExamples <= this.batchSize) {
                list.add(next);
                continue;
            }
            org.nd4j.linalg.dataset.DataSet toKeep = (org.nd4j.linalg.dataset.DataSet)next.getRange(0, this.batchSize - countSoFar);
            org.nd4j.linalg.dataset.DataSet toCache = (org.nd4j.linalg.dataset.DataSet)next.getRange(this.batchSize - countSoFar, nExamples);
            list.add(toKeep);
            this.queued.add(toCache);
        }
        if (this.inputColumns == -1) {
            org.nd4j.linalg.dataset.DataSet temp = (org.nd4j.linalg.dataset.DataSet)list.get(0);
            this.inputColumns = temp.getFeatureMatrix().size(1);
            this.totalOutcomes = temp.getLabels().size(1);
        }
        org.nd4j.linalg.dataset.DataSet out = list.size() == 1 ? (org.nd4j.linalg.dataset.DataSet)list.get(0) : org.nd4j.linalg.dataset.DataSet.merge(list);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)out);
        }
        this.cursor += out.numExamples();
        return out;
    }

    public int totalExamples() {
        throw new UnsupportedOperationException("Not supported");
    }

    public int inputColumns() {
        if (this.inputColumns != -1) {
            return this.inputColumns;
        }
        this.prefetchBatchSetInputOutputValues();
        return this.inputColumns;
    }

    public int totalOutcomes() {
        if (this.totalOutcomes != -1) {
            return this.totalOutcomes;
        }
        this.prefetchBatchSetInputOutputValues();
        return this.totalOutcomes;
    }

    public void reset() {
        throw new UnsupportedOperationException("Reset not supported");
    }

    public int batch() {
        return this.batchSize;
    }

    public int cursor() {
        return this.cursor;
    }

    public int numExamples() {
        return this.totalExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    private void prefetchBatchSetInputOutputValues() {
        if (!this.iterator.hasNext()) {
            return;
        }
        org.nd4j.linalg.dataset.DataSet next = this.iterator.next();
        this.inputColumns = next.getFeatureMatrix().size(1);
        this.totalOutcomes = next.getLabels().size(1);
        this.queued.add(next);
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

