/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.NeuralNetPlotter;

public class GradientPlotterIterationListener
implements IterationListener {
    private int iterations = 10;
    private NeuralNetPlotter plotter = new NeuralNetPlotter();
    private boolean renderFirst = false;
    private boolean invoked = false;

    @Override
    public boolean invoked() {
        return this.invoked;
    }

    @Override
    public void invoke() {
        this.invoked = true;
    }

    public GradientPlotterIterationListener(int iterations, boolean renderFirst) {
        this.iterations = iterations;
        this.renderFirst = renderFirst;
    }

    public GradientPlotterIterationListener(int iterations, NeuralNetPlotter plotter) {
        this.iterations = iterations;
        this.plotter = plotter;
    }

    public GradientPlotterIterationListener(int iterations, NeuralNetPlotter plotter, boolean renderFirst) {
        this.iterations = iterations;
        this.plotter = plotter;
        this.renderFirst = renderFirst;
    }

    public GradientPlotterIterationListener(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (iteration == 0 && this.renderFirst || iteration > 0 && iteration % this.iterations == 0) {
            this.invoke();
            Layer layer = (Layer)model;
            this.plotter.updateGraphDirectory(layer);
            this.plotter.plotNetworkGradient(layer, layer.gradient());
        }
    }
}

